package com.bcxin.risk.common.dao;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.activity.dto.data.ActivityDataDTO;

import java.util.List;
import java.util.Map;

public interface ScheduleDao extends BaseDao {

	/**
	 * 
	 * <b>Function 查询需要将活动状态变成结束状态的活动</b> 
	 * 
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	List<String> findNeedEndReport();
	
	List<String> findNeedEndReport(Long reportId);

	/**
	 * 
	 * <b>Function 查询需要完成合同认证的活动</b> 
	 * 
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	List<ActivityDataDTO> findNeedCompleteContract();

	/**
	 * 
	 * <b>Function 查询需要完成合同认证的活动task中的查询，根据report来统计完成了多少合同项</b> 
	 * 
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	Map<String, String> countContractByActivity(String activityId);

	/**
	 * 
	 * <b>Function 查询需要完成合同认证的活动task中的查询，根据report来统计多少服务提供商</b> 
	 * 
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	Map<String, String> countCooperByReport(String reportId);

	

}