package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.search.ActivityMaterialSearchDTO;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.user.domain.User;

import java.util.List;
import java.util.Map;

/**
 * 状态表数据类
 * @author Ethan
 */
public interface ActivityMaterialDao extends IDao<ActivityMaterial> {

    ActivityMaterial findActivityMaterialByOid(Long oid);

    List<ActivityMaterial> findActivityMaterialList(ActivityMaterialSearchDTO searchDto);

    List<ActivityMaterial> findActivityMaterialByActivity(Activity activity);

    List<ActivityMaterial> findAcMaterialByActivityAndUser(Activity activity, User user);

    ActivityMaterial findActivityMaterialByActivity(Activity activity,String materialType);

    void mergeActivityMaterial(ActivityMaterial activityMaterial);

    void updateActivityMaterialByDto(ActivityMaterialSearchDTO dto);

    //查找ActivityMaterial 对象
    ActivityMaterial findActivityMaterial(ActivityMaterialSearchDTO searchDto);

    Map<String,Object> querySubReport(Activity activity);

}
