package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.data.ActivityDataDTO;
import com.bcxin.risk.activity.dto.data.BLBCommunicationDto;
import com.bcxin.risk.activity.dto.search.ActivitySearchDTO;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.domain.User;

import java.util.List;
import java.util.Map;

public interface ActivityDao extends IDao<Activity> {


    List<Activity> activityList();

    Activity findActivityByOid(Long oid);

    Activity findActivityByName(String name);

    List<ActivityDataDTO> findActivityByActivityName(String activityName,String filterId);

    Activity findActivityByActivityNo(String activityNo);

    List<ActivityDataDTO> findActivityDtoList(ActivitySearchDTO searchDto, Page page);

    List<ActivityDataDTO> findActivityList(ActivitySearchDTO searchDto, Page page);

    List findActivityHistoryList(ActivitySearchDTO searchDto, DwzPage page);

    Map<String, String> countActivity(ActivitySearchDTO dto);

    List<ActivityDataDTO> findActivityByApprovalStatus(ActivitySearchDTO activitySearchDTO, Page page);

    Map<String, String> getActivitySuccessCount(User user,Long orgId);

    List<ActivityDataDTO> findUnInsureReportList(User user, String productType);

    List<BLBCommunicationDto> findBLBCommunicationDtoList(Long user_id,String activity_type);

    List<ActivityDataDTO> findTicketList(ActivitySearchDTO searchDto, Page page);

    /**
     * 根据评估机构获取对应的活动
     * @param orgId
     * @return
     */
    List<ActivityDataDTO> findActivityByOrgId(Long orgId);

    /**
     * 根据承办方获取对应的活动
     * @param contractId
     * @return
     */
    List<ActivityDataDTO> findActivityByContractId(Long contractId);

    Map<String,String> activityCount(Long oid);

    List<Map<String, Object>> countAmountByActivity(Long oid);

    List<Activity> activityPushList(String isPushToSB);

    /**
     * 获取已经开始的活动
     * @return
     */
    List<Activity> activityStarList();
}
