/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.dao.RoleDao;
import com.bcxin.risk.user.domain.Role;
import com.bcxin.risk.user.dto.search.UserRoleSearchDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="roleDao")
public class RoleDaoImpl
extends DaoImpl<Role>
implements RoleDao {
    public List<Role> findRoleByOrgType(String orgType, String serviceOrgType, String active, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)orgType)) {
            criterionList.add(Restrictions.eq((String)"orgType", (Object)orgType));
        }
        if (StringUtil.isNotEmpty((String)active)) {
            criterionList.add(Restrictions.eq((String)"active", (Object)active));
        }
        if (StringUtil.isNotEmpty((String)serviceOrgType)) {
            criterionList.add(Restrictions.eq((String)"serviceOrgType", (Object)serviceOrgType));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public Role findRoleByOid(Long oid) {
        return (Role)this.selectById(oid);
    }

    public Role findRoleByRoleCode(String roleCode) {
        return (Role)this.selectOne(CriterionWrapper.instance().eq("roleCode", (Object)roleCode));
    }

    public List findRoleList(UserRoleSearchDto dto, DwzPage page) {
        Long oid = dto.getUser_id();
        String sql = oid == null ? "SELECT c.oid,DATE_FORMAT(c.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,c.active,c.orgType,c.roleCode,c.roleDesc,c.roleName FROM risk_role c WHERE c.active = '1' " : "SELECT c.oid,DATE_FORMAT(c.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,c.active,c.orgType,c.roleCode,c.roleDesc,c.roleName, (CASE WHEN (SELECT COUNT(1) FROM risk_user_role WHERE role_id = c.oid AND user_id = " + oid + ")>0 THEN 1 ELSE 0 END) AS xzbz FROM risk_role c WHERE active = '1' AND EXISTS (SELECT 1 FROM risk_se_user a , risk_org b LEFT JOIN risk_serviceOrg d ON d.oid = b.oid WHERE a.org_id = b.oid AND a.active = '1' AND a.oid = " + oid + " AND b.orgType = c.orgType AND IFNULL(d.serviceOrgType,99) = IFNULL(c.serviceOrgType,99) ) ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (StringUtil.isNotEmpty((String)dto.getOrgType())) {
            sql = sql + "AND c.orgType = " + dto.getOrgType() + " ";
        }
        if (StringUtil.isNotEmpty((String)dto.getRoleCode())) {
            sql = sql + "AND c.roleCode = " + dto.getRoleCode() + " ";
        }
        if (StringUtil.isNotEmpty((String)dto.getRoleName())) {
            sql = sql + "AND c.roleName like '%" + dto.getRoleName() + "%' ";
        }
        sql = sql + " ORDER BY c.createOn,c.oid DESC";
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public List<Map<String, Object>> findRoleByName(Role role) {
        String sql = "SELECT oid FROM risk_role  WHERE roleName = " + role.getRoleName() + " AND active =" + role.getActive();
        if (role.getOid() != null) {
            sql = sql + " AND oid <> " + role.getOid();
        }
        SelectWrapper wrapper = SelectWrapper.instance();
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public Integer updateRole(Role role) {
        String sql = "Update risk_role  SET roleName = '" + role.getRoleName() + "' , orgType = '" + role.getOrgType() + "' , roleCode = '" + role.getRoleCode() + "' , roleDesc = '" + role.getRoleDesc() + "' , updateOn = SYSDATE()  WHERE oid = " + role.getOid() + "";
        return this.executeSqlUpdate(sql);
    }

    public Integer invalidRole(Role role) {
        String sql = "Update risk_role  SET active = '" + role.getActive() + "' , updateOn = SYSDATE()  WHERE oid = " + role.getOid() + "";
        return this.executeSqlUpdate(sql);
    }
}

