/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.user.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.expert.dto.ExpertPublicDto;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.dao.ExpertUserDao;
import com.bcxin.risk.user.domain.ExpertUser;
import com.bcxin.risk.user.dto.search.ExpertUserSearchDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.stereotype.Repository;

@Repository(value="expertUserDao")
public class ExpertUserDaoImpl
extends DaoImpl<ExpertUser>
implements ExpertUserDao {
    public ExpertUser findExpertUserByOid(Long oid) {
        return (ExpertUser)this.selectById(oid);
    }

    public ExpertUser findUserByName(String name) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"userName", (Object)name));
        List list = this.selectList(criterionList);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (ExpertUser)list.get(0);
    }

    public List findExpertUserList(ExpertUserSearchDto searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT  u.oid, u.realName, u.userName, u.phone, u.active, e.source, e.expertCategory, u.userType, e.jobLiveAddr, professional, p.label as professionalName, e.expertSource, e. LEVEL, e.taskQuote, o.name AS orgName, DATE_FORMAT(u.createOn,'%Y-%m-%d %H:%i:%s') AS createOn  FROM risk_se_user u inner join risk_expertuser e on u.oid=e.oid AND e.checkStatus =2 left join risk_org o on o.oid=e.serviceOrg_id  left join (select value,label from sys_dict t where t.type='PROFESSIONTYPE') p on p.value=e.professional  where 1=1 ";
        if (StringUtil.isNotEmpty((String)searchDto.getName())) {
            sql = sql + " and u.realName LIKE '%" + searchDto.getName() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyName())) {
            sql = sql + " and (u.realName LIKE '%" + searchDto.getKeyName() + "%' or u.userName LIKE '%" + searchDto.getKeyName() + "%' or u.phone like '%" + searchDto.getKeyName() + "%'or o.name like '%" + searchDto.getKeyName() + "%'or p.label like '%" + searchDto.getKeyName() + "%')";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getLevel())) {
            sql = sql + " and e.level='" + searchDto.getLevel() + "'";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getUserType())) {
            sql = sql + " and u.userType='" + searchDto.getUserType() + "'";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getExpertSource())) {
            sql = sql + " and e.expertSource='" + searchDto.getExpertSource() + "'";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActive())) {
            sql = sql + " and u.active='" + searchDto.getActive() + "'";
        }
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + " ORDER BY u.updateOn DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public List<String> findComposeExpertUserId() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select eu.oid from RISK_ExpertUser eu  inner join risk_se_user u on u.oid= eu.oid  where active =1 and (eu.expertTaskType = 2 or eu.expertTaskType = 3)  ORDER BY u.oid";
        List result = this.queryMaps(sql, (Wrapper)wrapper);
        ArrayList lists = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty((Collection)result)) {
            for (Map map : result) {
                lists.add(map.get("oid").toString());
            }
        }
        return lists;
    }

    public List<ExpertUser> findUserByOrgIdAndUserType(Long orgId, String userType, String status) {
        ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
        criterions.add(Restrictions.eq((String)"active", (Object)"1"));
        criterions.add(Restrictions.eq((String)"userType", (Object)userType));
        criterions.add(Restrictions.eq((String)"checkStatus", (Object)status));
        if (orgId != null) {
            criterions.add(Restrictions.eq((String)"org.oid", (Object)orgId));
        }
        return this.selectList(criterions);
    }

    public List<ExpertUser> findUserByOrgIdAndUserTypeAndKTType(Long orgId, String userType, String status, Collection<String> tkType) {
        ArrayList<Object> criterions = new ArrayList<Object>();
        criterions.add(Restrictions.eq((String)"active", (Object)"1"));
        criterions.add(Restrictions.eq((String)"userType", (Object)userType));
        criterions.add(Restrictions.eq((String)"checkStatus", (Object)status));
        if (tkType == null) {
            return Lists.newArrayList();
        }
        criterions.add(Restrictions.in((String)"ktType", tkType));
        if (orgId != null) {
            criterions.add(Restrictions.eq((String)"org.oid", (Object)orgId));
        }
        return this.selectList(criterions);
    }

    public List<ExpertPublicDto> findExpertPublicList(ExpertPublicDto dto, Page page) {
        String sql = "select  A.oid, B.realName, A.`level`, A.expertCategory, A.taskQuote, A.professional, A.jobLiveAddr, A.jobLiveAddrCode, C.label as professionalName from risk_expertuser A  inner join risk_se_user B on A.oid=B.oid  left JOIN (SELECT label,`value` FROM sys_dict t WHERE type = 'PROFESSIONTYPE') C on C.`value`=A.professional  where 1=1 ";
        if (StringUtil.isNotEmpty((String)dto.getExpertSource())) {
            sql = sql + " and A.expertSource='" + dto.getExpertSource() + "' ";
        }
        if (StringUtil.isNotEmpty((String)dto.getUserType())) {
            sql = sql + " and B.userType='" + dto.getUserType() + "' ";
        }
        if (!ObjectUtil.equal((Object)dto.getSelectAll(), (Object)"1")) {
            sql = sql + " and A.jobLiveAddrCode like '" + dto.getSelectProvince() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)dto.getKeyword())) {
            sql = sql + " and (B.realName like '%" + dto.getKeyword() + "%' ";
            sql = sql + " or C.label like '%" + dto.getKeyword() + "%' ";
            sql = sql + " or A.jobLiveAddr like '%" + dto.getKeyword() + "%' ";
            sql = sql + " or A.expertCategory like '%" + dto.getKeyword() + "%') ";
        }
        sql = sql + " ORDER BY A.createOn desc";
        ArrayList dtoList = Lists.newArrayList();
        SelectWrapper wrapper = SelectWrapper.instance();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            ExpertPublicDto publicDto = new ExpertPublicDto(result);
            publicDto.setPage(page);
            dtoList.add(publicDto);
        });
        return dtoList;
    }
}

