/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.ServiceOrgAuth;
import com.bcxin.risk.org.domain.ServiceOrgAuthDao;
import com.bcxin.risk.user.dao.ExpertRegionDao;
import com.bcxin.risk.user.domain.ExpertRegion;
import com.bcxin.risk.user.domain.ExpertUser;
import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.user.dto.data.ExpertRegionDataDto;
import com.bcxin.risk.user.dto.data.ExpertUserDataDto;
import com.bcxin.risk.user.dto.search.ExpertRegionSearchDto;
import com.bcxin.risk.user.dto.search.ExpertUserSearchDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="expertRegionDao")
public class ExpertRegionDaoImpl
extends DaoImpl<ExpertRegion>
implements ExpertRegionDao {
    @Autowired
    private ServiceOrgAuthDao serviceOrgAuthDao;

    public ExpertRegion findExpertRegionByOid(Long oid) {
        return (ExpertRegion)this.selectById(oid);
    }

    public List<ExpertRegion> findExpertRegionListByOid(long oid) {
        return this.selectList(CriterionWrapper.instance().eq("user_id", (Object)oid));
    }

    public List<ExpertRegion> findExpertRegionList(ExpertRegionSearchDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getRegion() != null) {
            criterionList.add(Restrictions.eq((String)"region_id", (Object)searchDto.getRegion()));
        }
        if (searchDto.getExpertUser() != null) {
            criterionList.add(Restrictions.eq((String)"user_id", (Object)searchDto.getExpertUser().getOid()));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public List<ExpertUserDataDto> findExpertUserDataList(ExpertUserSearchDto expertUserSearchDto, Activity activity, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT u.oid, u.realName,u.userName,u.phone, u.active,e.serviceOrg_id,e.source,e.expertCategory ,DATE_FORMAT(u.createOn,'%Y-%m-%d %H:%i:%s')  AS createOn FROM risk_se_user u,risk_expertuser e WHERE e.oid = u.oid AND  u.active = 1 ";
        if (StringUtil.isNotEmpty((String)expertUserSearchDto.getExpertType())) {
            sql = sql + " and ( e.expertTaskType = 3 or e.expertTaskType = " + expertUserSearchDto.getExpertType() + ")";
        }
        if (StringUtil.isNotEmpty((String)expertUserSearchDto.getKeyName())) {
            sql = sql + " and (u.realName LIKE '%" + expertUserSearchDto.getKeyName() + "%' or e.expertCategory LIKE '%" + expertUserSearchDto.getKeyName() + "%' )";
        }
        if (StringUtil.isNotEmpty((String)expertUserSearchDto.getName())) {
            sql = sql + " and u.realName LIKE '%" + expertUserSearchDto.getName() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)expertUserSearchDto.getExpertCategory())) {
            sql = sql + " and e.expertCategory LIKE '%" + expertUserSearchDto.getExpertCategory() + "%' ";
        }
        wrapper.orderBy("oid", false);
        List list = Lists.newArrayList();
        if (page == null) {
            list = this.queryMaps(sql, (Wrapper)wrapper);
        } else {
            Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
            list = pageList.getRecords();
        }
        ArrayList<ExpertUserDataDto> dtoList = new ArrayList<ExpertUserDataDto>();
        list.forEach(result -> {
            ExpertUserDataDto dto = new ExpertUserDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<ExpertUserDataDto> findExpertsList(ExpertUserSearchDto expertUserSearchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT  u.oid, u.realName, u.userName, u.phone, u.active, u.ktType, CASE WHEN ( u.ktType = '17' OR u.ktType = '23' OR u.ktType = '24' ) THEN ( SELECT expertName FROM risk_expert_type WHERE expertType = u.ktType ) ELSE IF(e.expertTaskType = 1,'\u52d8\u67e5\u4e13\u5bb6',IF(e.expertTaskType = 2,'\u64b0\u5199\u4e13\u5bb6','\u52d8\u67e5\u548c\u64b0\u5199\u4e13\u5bb6')) END AS userTypeName, IF(e.expertTaskType = 1 AND u.org_id=" + expertUserSearchDto.getOrg().getOid() + ",1,0) as 'isUpdateKtType',  e.serviceOrg_id, e.source, e.expertCategory, e.expertTaskType, e.expertSource, DATE_FORMAT( u.createOn, '%Y-%m-%d %H:%i:%s' ) AS createOn, e.professional, g.professionalName, e.jobLiveAddr FROM risk_se_user u inner join risk_expertuser e on (u.oid=e.oid and e.checkStatus = 2)  left join (SELECT label AS professionalName, `value` AS professional FROM sys_dict WHERE type = 'PROFESSIONTYPE') g on g.professional = e.professional  WHERE u.active = '1' AND u.usertype != '15' ";
        if (StringUtil.isNotEmpty((String)expertUserSearchDto.getUserType())) {
            sql = sql + " and u.ktType='" + expertUserSearchDto.getUserType() + "' ";
        }
        if (StringUtil.isNotEmpty((String)expertUserSearchDto.getLevel())) {
            sql = sql + " and e.level='" + expertUserSearchDto.getLevel() + "' ";
        }
        if (StringUtil.isNotEmpty((String)expertUserSearchDto.getExpertSource())) {
            sql = sql + " and e.expertSource='" + expertUserSearchDto.getExpertSource() + "' ";
        }
        if (expertUserSearchDto.getOrg() != null) {
            sql = this.isShareExpertAuth(expertUserSearchDto.getOrg().getOid()) ? sql + " and (u.org_id=" + expertUserSearchDto.getOrg().getOid() + " or e.expertSource='" + "public" + "')" : sql + " and (u.org_id=" + expertUserSearchDto.getOrg().getOid() + ")";
        }
        if (StringUtil.isNotEmpty((String)expertUserSearchDto.getKeyName())) {
            sql = sql + " and (u.realName LIKE '%" + expertUserSearchDto.getKeyName() + "%' or e.expertCategory LIKE '%" + expertUserSearchDto.getKeyName() + "%' )";
        }
        if (StringUtil.isNotEmpty((String)expertUserSearchDto.getName())) {
            sql = sql + " and (u.realName LIKE '%" + expertUserSearchDto.getName() + "%'  or g.professionalName LIKE '%" + expertUserSearchDto.getName() + "%' or e.jobLiveAddr LIKE '%" + expertUserSearchDto.getName() + "%')";
        }
        if (StringUtil.isNotEmpty((String)expertUserSearchDto.getExpertCategory())) {
            sql = sql + " and e.expertCategory LIKE '%" + expertUserSearchDto.getExpertCategory() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)expertUserSearchDto.getActive())) {
            sql = sql + " and u.active = '" + expertUserSearchDto.getActive() + "' ";
        }
        if (StringUtil.isNotEmpty((String)expertUserSearchDto.getExpertType())) {
            sql = sql + " and (e.expertTaskType = 3 or e.expertTaskType = " + expertUserSearchDto.getExpertType() + ") ";
        }
        wrapper.orderBy("oid", false);
        List list = Lists.newArrayList();
        if (page == null) {
            list = this.queryMaps(sql, (Wrapper)wrapper);
        } else {
            Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
            list = pageList.getRecords();
        }
        ArrayList<ExpertUserDataDto> dtoList = new ArrayList<ExpertUserDataDto>();
        list.forEach(result -> {
            ExpertUserDataDto dto = new ExpertUserDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<ExpertRegionDataDto> findExpertRegionListByExpert(ExpertUser expertUser) {
        String sql = " SELECT a.oid, (CASE WHEN a.level = '1'  THEN a.province  WHEN a.level = '2'  THEN a.city  ELSE a.area END ) AS area, a.parent_id, a.level, (CASE WHEN (SELECT COUNT(1)  FROM risk_expert_region  WHERE region_id = a.oid  AND user_id = " + expertUser.getOid() + ")>0  THEN 1  ELSE 0 END) AS xzbz  FROM sys_region a  WHERE a.level = 2 ";
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.orderBy("a.oid", true);
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        ArrayList dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map map = result;
            ExpertRegionDataDto dto = new ExpertRegionDataDto(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public void deleteExpertRegion(User user) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("user_id", (Object)user.getOid());
        this.delete((Wrapper)wrapper);
    }

    public void savemore(String result, long expertOid) {
        String sql = "INSERT INTO risk_expert_region (createOn,user_id,region_level,region_id)   SELECT SYSDATE()," + expertOid + ",level,oid FROM sys_region WHERE oid IN (" + result + ")";
        String sql1 = "INSERT INTO risk_expert_region (createOn,user_id,region_level,region_id)   SELECT SYSDATE()," + expertOid + ",'1',oid FROM sys_region WHERE oid IN (select parent_id from sys_region WHERE oid IN (" + result + "))";
        this.executeSqlUpdate(sql);
        this.executeSqlUpdate(sql1);
    }

    public boolean isShareExpertAuth(Long orgId) {
        ServiceOrgAuth serviceOrgAuth = this.serviceOrgAuthDao.selectByType(orgId.longValue(), "SA6");
        if (serviceOrgAuth == null) {
            return false;
        }
        return "1".equals(serviceOrgAuth.getAuthValue());
    }
}

