/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.statistics.dao;

import com.bcxin.risk.base.dao.BaseDaoImpl;
import com.bcxin.risk.base.dao.QueryHelper;
import com.bcxin.risk.statistics.dao.StatisticsDao;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository(value="statisticsDao")
public class StatisticsDaoImpl
extends BaseDaoImpl
implements StatisticsDao {
    public Map<String, String> countReport() {
        HashMap countMap = Maps.newHashMap();
        HashMap paramMap1 = Maps.newHashMap();
        StringBuilder sql1 = new StringBuilder("select count(r.oid) as reportTotal ,sum(d.number) as peopleTotal  ,sum(case r.approvalStatus when 'REJECT' then 1 else 0 end) as rejectTotal ,sum(case r.reportSchedule when 'END' then 0 else 1 end) as duringTotal from risk_report r  inner join risk_reportdetail d on d.reportId = r.oid  where r.reportStatus = 'EFFECT' ");
        List<Object> list1 = QueryHelper.findBySql(sql1.toString(), paramMap1);
        for (Object object : list1) {
            Map result = (Map)object;
            countMap.put("reportTotal", result.get("reportTotal") == null ? "0" : result.get("reportTotal").toString());
            countMap.put("peopleTotal", result.get("peopleTotal") == null ? "0" : result.get("peopleTotal").toString());
            countMap.put("rejectTotal", result.get("rejectTotal") == null ? "0" : result.get("rejectTotal").toString());
            countMap.put("duringTotal", result.get("duringTotal") == null ? "0" : result.get("duringTotal").toString());
        }
        HashMap paramMap2 = Maps.newHashMap();
        StringBuilder sql2 = new StringBuilder("select count(r.oid) as todayTotal from risk_report r  inner join risk_reportdetail d on d.reportId = r.oid  where r.reportStatus = 'EFFECT' and SYSDATE() BETWEEN d.startDate and d.endDate");
        List<Object> list2 = QueryHelper.findBySql(sql2.toString(), paramMap2);
        for (Object object : list2) {
            Map result = (Map)object;
            countMap.put("todayTotal", result.get("todayTotal") == null ? "0" : result.get("todayTotal").toString());
        }
        HashMap paramMap3 = Maps.newHashMap();
        StringBuilder sql3 = new StringBuilder("select count(DISTINCT d.cmsId) as addressTotal from risk_report_dedecmsaddress d ");
        List<Object> list3 = QueryHelper.findBySql(sql3.toString(), paramMap3);
        for (Object object : list3) {
            Map result = (Map)object;
            countMap.put("addressTotal", result.get("addressTotal") == null ? "0" : result.get("addressTotal").toString());
        }
        return countMap;
    }

    public Map<String, String> countArea() {
        HashMap countMap = Maps.newHashMap();
        HashMap paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder("select count(DISTINCT r.oid) as provinceTotal,count(DISTINCT rr.oid) as cityTotal,count(DISTINCT rrr.oid) as areaTotal from risk_reportdetail d inner join risk_region r on r.oid = d.provinceId inner join risk_region rr on rr.oid = d.cityId inner join risk_region rrr on rrr.oid = d.areaId");
        List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
        for (Object object : list) {
            Map result = (Map)object;
            countMap.put("provinceTotal", result.get("provinceTotal") == null ? "0" : result.get("provinceTotal").toString());
            countMap.put("cityTotal", result.get("cityTotal") == null ? "0" : result.get("cityTotal").toString());
            countMap.put("areaTotal", result.get("areaTotal") == null ? "0" : result.get("areaTotal").toString());
        }
        return countMap;
    }
}

