/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.report.material;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.material.dao.MaterialFormMenuDao;
import com.bcxin.risk.report.material.domain.MaterialFormMenu;
import com.bcxin.risk.report.material.dto.MaterialFormMenuDTO;
import com.bcxin.risk.report.material.dto.MaterialFormMenuSearchDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class MaterialFormMenuDaoImpl
extends DaoImpl<MaterialFormMenu>
implements MaterialFormMenuDao {
    public MaterialFormMenu findMaterialFormMenuByOid(Long oid) {
        return (MaterialFormMenu)this.selectById(oid);
    }

    public List<MaterialFormMenu> selectListByDto(MaterialFormMenuSearchDto searchDto) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getMaterialFormClass() != null) {
            criterionList.add(Restrictions.eq((String)"formClass", (Object)searchDto.getMaterialFormClass()));
        }
        if (searchDto.getActivity() != null) {
            criterionList.add(Restrictions.eq((String)"activity", (Object)searchDto.getActivity()));
        }
        if (searchDto.getMenuCodes() != null && searchDto.getMenuCodes().length > 0) {
            criterionList.add(Restrictions.in((String)"menuCode", (Object[])searchDto.getMenuCodes()));
        }
        return this.selectList(criterionList, Order.asc((String)"seq"));
    }

    public List<MaterialFormMenu> selectListByActivity(Activity activity) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"activity", (Object)activity));
        return this.selectList(criterionList, Order.asc((String)"seq"));
    }

    public List<MaterialFormMenuDTO> selectDTOByOrg(Activity activity) {
        String sql = "select m.oid,m.menuCode,m.menuName,m.class_id,m.required,m.completed ,so.oid as orgId,so.serviceOrgType as orgType,o.`name` as orgName,so.contactName,so.contactPhone  from risk_materialformorg mo  inner join risk_materialformmenu m on mo.menuCode = m.menuCode inner join risk_activity a on a.oid = m.activity_id inner join risk_activity_cooper c on c.activity_id = a.oid inner join risk_org o on o.oid = c.org_id  inner join risk_serviceorg so on so.oid = o.oid and so.serviceOrgType = mo.orgType ";
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("a.oid", (Object)activity.getOid());
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        ArrayList dtoList = Lists.newArrayList();
        list.forEach(result -> {
            MaterialFormMenuDTO dto = new MaterialFormMenuDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public void deleteByActivityId(Long activityId) {
        String sql = "delete from risk_materialformmenu where activity_id = " + activityId;
        this.executeSqlUpdate(sql);
    }

    public List<Map<String, Object>> getFormMenuRequired(Long activityId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select A.oid menuId,A.menuCode,A.menuName,\n sum(\n case when A.required=1 and B.isRequired=1 then 1 else 0 end) requiredNum\n from RISK_MaterialFormMenu A\n inner join risk_materialformattr B on A.oid=B.menu_id\n where A.activity_id=" + activityId + " group by A.oid,A.menuCode,A.menuName";
        return this.queryMaps(sql, (Wrapper)wrapper);
    }
}

