/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.report.material;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.report.material.dao.MaterialFormClassDao;
import com.bcxin.risk.report.material.domain.MaterialFormClass;
import com.bcxin.risk.report.material.dto.MaterialFormClassSearchDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class MaterialFormClassDaoImpl
extends DaoImpl<MaterialFormClass>
implements MaterialFormClassDao {
    public MaterialFormClass findMaterialFormClassByOid(Long oid) {
        return (MaterialFormClass)this.selectById(oid);
    }

    public List<MaterialFormClass> findMaterialFormClassList(MaterialFormClassSearchDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getMenus() != null) {
            criterionList.add(Restrictions.eq((String)"menus", (Object)searchDto.getMenus()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getClassCode())) {
            criterionList.add(Restrictions.eq((String)"classCode", (Object)searchDto.getClassCode()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getClassName())) {
            criterionList.add(Restrictions.eq((String)"className", (Object)searchDto.getClassName()));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public List<MaterialFormClass> findAll() {
        Order order = Order.asc((String)"seq");
        List list = this.selectList(order);
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    public List<Map<String, Object>> getFormClassProgress(Long activityId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT A.oid as classId,A.className,\n count(B.oid) as totalMenuNum,\n sum(case when B.completed=1 then 1 else 0 end) completedNum,\n CAST(sum(case when B.completed=1 then 1 else 0 end) * 100 /count(B.oid) AS signed ) as progress\n from RISK_MaterialFormClass A\n inner join RISK_MaterialFormMenu B on A.oid=B.class_id\n where B.activity_id=" + activityId + " group by A.oid,A.className";
        return this.queryMaps(sql, (Wrapper)wrapper);
    }
}

