/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.report.material;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.DomainDateUtil;
import com.bcxin.risk.hibernateplus.condition.UpdateWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.report.material.dao.ContractDao;
import com.bcxin.risk.report.material.domain.Contract;
import com.bcxin.risk.report.material.dto.ContratSearchDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="contractDao")
public class ContractDaoImpl
extends DaoImpl<Contract>
implements ContractDao {
    public Contract findByKey(Activity activity, String inputKey) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"activity", (Object)activity));
        criterionList.add(Restrictions.eq((String)"inputKey", (Object)inputKey));
        return (Contract)this.selectOne(criterionList);
    }

    public Contract findContractByOid(Long oid) {
        return (Contract)this.selectById(oid);
    }

    public List<Contract> findContractList(ContratSearchDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getUser() != null) {
            criterionList.add(Restrictions.eq((String)"user", (Object)searchDto.getUser()));
        }
        if (searchDto.getActivity() != null) {
            criterionList.add(Restrictions.eq((String)"activity", (Object)searchDto.getActivity()));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public void updateActive(Activity activity) {
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq("activity_id", (Object)activity.getOid());
        wrapper.set("active", "1");
        wrapper.set("updateOn", "'" + DomainDateUtil.getCurrentDateTime() + "'");
        this.update((Wrapper)wrapper);
    }
}

