/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.policy;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.RoleInPolicyDao;
import com.bcxin.risk.policy.domain.InsurancePolicy;
import com.bcxin.risk.policy.domain.RoleInPolicy;
import com.bcxin.risk.policy.dto.search.RoleInPolicySerachDto;
import com.bcxin.risk.policy.enums.RoleKind;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="roleInPolicyDao")
public class RoleInPolicyDaoImpl
extends DaoImpl<RoleInPolicy>
implements RoleInPolicyDao {
    public RoleInPolicy findRoleInPolicyByOid(Long oid) {
        return (RoleInPolicy)this.selectById(oid);
    }

    public List<RoleInPolicy> findRoleInPolicyList(RoleInPolicySerachDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getInsurancePolicy() != null) {
            criterionList.add(Restrictions.eq((String)"insurancePolicy", (Object)searchDto.getInsurancePolicy()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getFullName())) {
            criterionList.add(Restrictions.eq((String)"readStatus", (Object)searchDto.getFullName()));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public RoleInPolicy findRoleInPolicyByKind(RoleKind kind, InsurancePolicy policy) {
        ArrayList criterions = new ArrayList();
        ArrayList criterionList = Lists.newArrayList();
        if (policy != null) {
            criterionList.add(Restrictions.eq((String)"insurancePolicy", (Object)policy));
        }
        criterionList.add(Restrictions.eq((String)"roleKind", (Object)kind));
        List plist = this.selectList(criterionList);
        if (plist.size() > 0) {
            return (RoleInPolicy)plist.get(0);
        }
        return null;
    }
}

