/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.policy;

import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.ProductIntroduceDao;
import com.bcxin.risk.policy.domain.InsuranceProduct;
import com.bcxin.risk.policy.domain.ProductIntroduce;
import com.bcxin.risk.policy.dto.ProductDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="productIntroduceDao")
public class ProductIntroduceDaoImpl
extends DaoImpl<ProductIntroduce>
implements ProductIntroduceDao {
    public ProductIntroduce findProductIntroduceByOid(Long oid) {
        return (ProductIntroduce)this.selectById(oid);
    }

    public List<ProductIntroduce> findProductIntroduceList(ProductDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getIntroduce() != null) {
            criterionList.add(Restrictions.eq((String)"introduce", (Object)searchDto.getIntroduce()));
        }
        if (searchDto.getProduct() != null) {
            criterionList.add(Restrictions.eq((String)"product", (Object)searchDto.getProduct()));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public ProductIntroduce findProductIntroduceByProduct(InsuranceProduct product) {
        return (ProductIntroduce)this.selectOne(CriterionWrapper.instance().eq("product", (Object)product));
    }
}

