/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.policy;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.InsurancePolicyDao;
import com.bcxin.risk.policy.domain.InsurancePolicy;
import com.bcxin.risk.policy.dto.data.PolicyDto;
import com.bcxin.risk.policy.dto.search.PolicySearchDto;
import com.bcxin.risk.policy.enums.PolicyStatus;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="insurancePolicyDao")
public class InsurancePolicyDaoImpl
extends DaoImpl<InsurancePolicy>
implements InsurancePolicyDao {
    public InsurancePolicy findInsurancePolicyByOid(Long oid) {
        return (InsurancePolicy)this.selectById(oid);
    }

    public List<InsurancePolicy> findInsurancePolicyList(PolicySearchDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getUser() != null) {
            criterionList.add(Restrictions.eq((String)"user", (Object)searchDto.getUser()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCname())) {
            criterionList.add(Restrictions.eq((String)"cname", (Object)searchDto.getCname()));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public InsurancePolicy findPolicyByActivity(Activity activity) {
        ArrayList criterionList = Lists.newArrayList();
        if (activity == null) {
            return null;
        }
        criterionList.add(Restrictions.eq((String)"activity", (Object)activity));
        List list = this.selectList(criterionList);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (InsurancePolicy)list.get(0);
    }

    public List<InsurancePolicy> findPolicyByUser(User user) {
        return this.selectList(CriterionWrapper.instance().eq("user", (Object)user));
    }

    public List<PolicyDto> findPolicyList(PolicySearchDto searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select i.oid,i.externalReference,DATE_FORMAT(i.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,pe.reportName,p.`name` as productName,i.policyStatus,i.policyType,i.premium as amount  ,i.policySerialNumber,i.inceptionDate,i.plannedEndDate,i.htPlannedEndDate,i.signedDate  ,DATE_FORMAT(i.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn,i.settlementStatus  from risk_insurancepolicy i inner join risk_insuranceproduct p on i.spec_Id = p.oid  inner join risk_policyextra pe on pe.policy_Id = i.oid  where 1=1 ";
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate())) {
            sql = sql + "and i.signedDate <= '" + searchDto.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + "and i.signedDate >= '" + searchDto.getEndDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderSerialNumber())) {
            sql = sql + "and i.policySerialNumber like '%" + searchDto.getOrderSerialNumber() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getExternalReference())) {
            sql = sql + "and i.externalReference like '%" + searchDto.getExternalReference() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStatus())) {
            sql = sql + "and i.policyStatus = '" + searchDto.getStatus() + "' ";
        }
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + " ORDER BY  i.createOn DESC ,i.oid DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage() + " ";
        }
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        list.forEach(result -> {
            PolicyDto dto = new PolicyDto(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<PolicyDto> findPolicyByUserPage(PolicySearchDto searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select i.oid,i.externalReference,DATE_FORMAT(i.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,pe.reportName,p.`name` as productName,i.policyStatus,i.policyType,i.premium as amount  ,i.policySerialNumber,i.inceptionDate,i.plannedEndDate,i.htPlannedEndDate,i.signedDate  ,DATE_FORMAT(i.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn,i.settlementStatus  from risk_insurancepolicy i inner join risk_insuranceproduct p on i.spec_Id = p.oid  inner join risk_policyextra pe on pe.policy_Id = i.oid  where i.user_id = " + searchDto.getUser().getOid() + " ";
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate())) {
            sql = sql + "and i.signedDate <= '" + searchDto.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + "and i.signedDate >= '" + searchDto.getEndDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCname())) {
            sql = sql + "and ( i.externalReference like '%" + searchDto.getCname() + "%' or pe.reportName like '%" + searchDto.getCname() + "%')";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderSerialNumber())) {
            sql = sql + "and i.policySerialNumber like '%" + searchDto.getOrderSerialNumber() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getExternalReference())) {
            sql = sql + "and i.externalReference like '%" + searchDto.getExternalReference() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStatus())) {
            sql = sql + "and i.policyStatus = '" + searchDto.getStatus() + "' ";
        }
        wrapper.orderBy(" i.createOn", false);
        wrapper.orderBy(" i.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            PolicyDto dto = new PolicyDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public void updReportPolicyStatus(Activity activity, PolicyStatus status) {
        String sql = "UPDATE  risk_insurancepolicy set  policyStatus = '" + status + "', updateOn = SYSDATE() where  reportId =" + activity.getOid();
        this.executeSqlUpdate(sql);
    }
}

