/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.org;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.ServiceOrg;
import com.bcxin.risk.org.domain.ServiceOrgDao;
import com.bcxin.risk.org.dto.ServiceOrgSearchDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class ServiceOrgDaoImpl
extends DaoImpl<ServiceOrg>
implements ServiceOrgDao {
    @Resource
    private BaseDao baseDao;

    public ServiceOrg findServiceOrgByOid(Long oid) {
        return (ServiceOrg)this.selectById(oid);
    }

    public List<Map<String, Object>> findServiceOrgList(ServiceOrgSearchDto searchDto, Page page) {
        String sql = "SELECT CONCAT(a.oid,'') oid,b.name,a.serviceOrgType,a.distributionOrg,a.contactName,a.contactPhone,a.contactAddress,a.experts,a.introduce,a.experience FROM risk_serviceOrg a , risk_org b WHERE a.oid  = b.oid ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (searchDto.getCity_id() != null) {
            int level = 2;
            if (String.valueOf(searchDto.getCity_id()).endsWith("0000")) {
                level = 1;
            }
            sql = sql + " AND EXISTS (SELECT 1 FROM risk_org_region WHERE org_id = a.oid AND region_level = '" + level + "' AND region_id = " + searchDto.getCity_id() + ")";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getName())) {
            sql = sql + " AND name like '%" + searchDto.getName() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getServiceOrgType())) {
            sql = sql + " AND serviceOrgType = " + searchDto.getServiceOrgType();
        }
        sql = sql + " AND b.active = 1 ";
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public List<ServiceOrg> findDshServiceOrgList(ServiceOrgSearchDto searchDto, DwzPage page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto != null) {
            if (StringUtil.isNotEmpty((String)searchDto.getName())) {
                criterionList.add(Restrictions.like((String)"name", (Object)("%" + searchDto.getName() + "%")));
            }
            if (StringUtil.isNotEmpty((String)searchDto.getServiceOrgType())) {
                criterionList.add(Restrictions.eq((String)"serviceOrgType", (Object)searchDto.getServiceOrgType()));
            }
        }
        criterionList.add(Restrictions.eq((String)"approvalStatus", (Object)"1"));
        ArrayList<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.desc((String)"updateOn"));
        if (page == null) {
            return this.baseDao.findByCriterion(ServiceOrg.class, (List)criterionList, orderList);
        }
        return this.baseDao.findByCriterionForPage(ServiceOrg.class, (List)criterionList, page, orderList);
    }

    public Map<String, String> countOrder(ServiceOrg org) {
        if (org == null) {
            return Maps.newHashMap();
        }
        StringBuilder sql = new StringBuilder("select  sum(case a.activityStatus when '50' then 1 else 0 end) as endtotal, sum(case a.activityStatus when '50' then 0 else 1 end) as duringtotal from RISK_ACTIVITY a   inner join RISK_ACTIVITY_COOPER cp on cp.activity_id = a.oid  inner join RISK_SERVICEORG org on cp.org_id = org.oid ");
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("org.oid", (Object)org.getOid());
        wrapper.notIn("a.activitySource", (Collection)Lists.newArrayList((Object[])new String[]{"2"}));
        HashMap countMap = Maps.newHashMap();
        Map result = this.queryMap(sql.toString(), (Wrapper)wrapper);
        countMap.put("endtotal", result.get("endtotal") == null ? "0" : result.get("endtotal").toString());
        countMap.put("duringtotal", result.get("duringtotal") == null ? "0" : result.get("duringtotal").toString());
        return countMap;
    }

    public List<Map<String, Object>> findServiceOrgByDtoForPage(ServiceOrgSearchDto dto, DwzPage page) {
        String sql = "SELECT DISTINCT a.oid, b. NAME as name, a.serviceOrgType, a.serviceMode, a.distributionOrg, a.contactName, a.contactPhone, a.contactAddress, c.userName, ( SELECT province FROM sys_region WHERE oid = b.province_id ) AS province, ( SELECT city FROM sys_region WHERE oid = b.city_id ) AS city, ( SELECT area FROM sys_region WHERE oid = b.area_id ) AS area FROM risk_serviceOrg a INNER JOIN risk_org b ON a.oid = b.oid LEFT JOIN risk_se_user c ON b.oid = c.org_id AND c.userType = '5' WHERE 1 = 1 ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (StringUtil.isNotEmpty((String)dto.getName())) {
            sql = sql + " AND name like '%" + dto.getName() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)dto.getServiceOrgType())) {
            sql = sql + " AND serviceOrgType = " + dto.getServiceOrgType();
        }
        sql = sql + " ORDER BY a.oid DESC ";
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public List<Map<String, Object>> findNeedSyncSPOrg() {
        String sql = "select   so.oid as 'orgId',  so.serviceOrgType as 'orgType',  o.name as 'orgName',  so.introduce as 'orgIntroduce',  so.Experience as 'orgExperience',  so.Experts as 'orgExperts',  so.ContactName as 'orgContactName',  so.ContactPhone as 'orgContactPhone',  so.ContactAddress as 'orgContactAddress',  DATE_FORMAT(o.createOn,'%Y-%m-%d %H:%i:%s') as 'registerTime',  o.province_id as 'provinceId',  o.city_id as 'cityId' , o.saasComId  from risk_serviceorg so  inner join risk_org o on so.oid = o.oid  where (so.syncSP = 0 or so.syncSP is null) and so.serviceOrgType = 1";
        SelectWrapper wrapper = SelectWrapper.instance();
        return this.queryMaps(sql, (Wrapper)wrapper);
    }
}

