/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.org;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.PendOrg;
import com.bcxin.risk.org.domain.PendOrgDao;
import com.bcxin.risk.org.dto.OrgDTO;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pendOrgDao")
public class PendOrgDaoImpl
extends DaoImpl<PendOrg>
implements PendOrgDao {
    @Autowired
    private BaseDao baseDao;

    public PendOrg findPendOrgByOid(Long oid) {
        return (PendOrg)this.selectById(oid);
    }

    public PendOrg findPendOrg(User user, String serviceOrgType) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"user", (Object)user));
        criterionList.add(Restrictions.eq((String)"serviceOrgType", (Object)serviceOrgType));
        List list = this.baseDao.findByCriterion(PendOrg.class, (List)criterionList);
        if (list != null && list.size() > 0) {
            return (PendOrg)list.get(0);
        }
        return null;
    }

    public List<PendOrg> findPendOrgList(OrgDTO orgDTO, DwzPage page) {
        HashMap params = Maps.newHashMap();
        ArrayList criterionList = Lists.newArrayList();
        if (orgDTO != null) {
            if (StringUtil.isNotEmpty((String)orgDTO.getUserName())) {
                criterionList.add(Restrictions.eq((String)"userName", (Object)orgDTO.getUserName()));
            }
            if (StringUtil.isNotEmpty((String)orgDTO.getName())) {
                criterionList.add(Restrictions.like((String)"name", (Object)("%" + orgDTO.getName() + "%")));
            }
            if (StringUtil.isNotEmpty((String)orgDTO.getServiceOrgType())) {
                criterionList.add(Restrictions.eq((String)"serviceOrgType", (Object)orgDTO.getServiceOrgType()));
            }
            if (StringUtil.isNotEmpty((String)orgDTO.getApprovalStatus())) {
                criterionList.add(Restrictions.eq((String)"approvalStatus", (Object)orgDTO.getApprovalStatus()));
            }
        }
        ArrayList<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.asc((String)"approvalStatus"));
        orderList.add(Order.desc((String)"createOn"));
        if (page == null) {
            return this.baseDao.findByCriterion(PendOrg.class, (List)criterionList, orderList);
        }
        return this.baseDao.findByCriterionForPage(PendOrg.class, (List)criterionList, page, orderList);
    }

    public List newPendOrg() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT a.`name`,a.userName,DATE_FORMAT( a.createOn ,'%Y-%m-%d %H:%i:%s' ) as createOn,a.serviceOrgType  FROM risk_pendOrg a WHERE 1=1 AND  approvalStatus = '1' ORDER BY createOn DESC LIMIT 5 ";
        return this.queryMaps(sql, (Wrapper)wrapper);
    }
}

