/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.org;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.InvoiceTemplate;
import com.bcxin.risk.org.domain.InvoiceTemplateDao;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.org.dto.InvoiceDto;
import com.bcxin.risk.org.dto.InvoiceTemplateSerachDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="invoiceTemplateDao")
public class InvoiceTemplateDaoImpl
extends DaoImpl<InvoiceTemplate>
implements InvoiceTemplateDao {
    @Autowired
    private BaseDao baseDao;

    public InvoiceTemplate findInvoiceTemplateByOid(Long oid) {
        return (InvoiceTemplate)this.selectById(oid);
    }

    public List<InvoiceTemplate> findInvoiceTemplateList(InvoiceTemplateSerachDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getOrg() != null) {
            criterionList.add(Restrictions.eq((String)"org", (Object)searchDto.getOrg()));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public InvoiceTemplate findInvoiceCompanyByOrg(Org org) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"org", (Object)org));
        List list = this.selectList(criterionList);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (InvoiceTemplate)list.get(0);
    }

    public InvoiceTemplate findActiveInvoiceByOrg(Org org) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"org", (Object)org));
        criterionList.add(Restrictions.eq((String)"approveActive", (Object)"1"));
        List list = this.selectList(criterionList);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (InvoiceTemplate)list.get(0);
    }

    public List<InvoiceTemplate> findInvoiceCompany(DwzPage page, Org org, InvoiceDto invoiceDto) {
        ArrayList criterionList = Lists.newArrayList();
        if (org != null) {
            criterionList.add(Restrictions.eq((String)"org", (Object)org));
        }
        if (invoiceDto != null) {
            if (StringUtil.isNotEmpty((String)invoiceDto.getCompanyName())) {
                criterionList.add(Restrictions.eq((String)"companyName", (Object)invoiceDto.getCompanyName()));
            }
            if (StringUtil.isNotEmpty((String)invoiceDto.getBankAccount())) {
                criterionList.add(Restrictions.eq((String)"bankAccount", (Object)invoiceDto.getBankAccount()));
            }
            if (StringUtil.isNotEmpty((String)invoiceDto.getRegisterAddress())) {
                criterionList.add(Restrictions.eq((String)"registerAddress", (Object)invoiceDto.getRegisterAddress()));
            }
            if (StringUtil.isNotEmpty((String)invoiceDto.getTaxpayerNumber())) {
                criterionList.add(Restrictions.eq((String)"taxpayerNumber", (Object)invoiceDto.getTaxpayerNumber()));
            }
            if (StringUtil.isNotEmpty((String)invoiceDto.getApproveActive())) {
                criterionList.add(Restrictions.eq((String)"approveActive", (Object)invoiceDto.getApproveActive()));
            }
            if (StringUtil.isNotEmpty((String)invoiceDto.getInvoiceType())) {
                criterionList.add(Restrictions.eq((String)"invoiceType", (Object)invoiceDto.getInvoiceType()));
            }
        }
        ArrayList<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.desc((String)"createOn"));
        if (page == null) {
            return this.baseDao.findByCriterion(InvoiceTemplate.class, (List)criterionList, orderList);
        }
        return this.baseDao.findByCriterionForPage(InvoiceTemplate.class, (List)criterionList, page, orderList);
    }

    public InvoiceTemplate findInvoiceCompanyByOrg(Org org, InvoiceDto invoiceDto) {
        List list;
        ArrayList criterionList = Lists.newArrayList();
        if (org != null) {
            criterionList.add(Restrictions.eq((String)"org", (Object)org));
        }
        if (invoiceDto != null && invoiceDto.getApproveActive() != null) {
            criterionList.add(Restrictions.eq((String)"invoiceActive", (Object)invoiceDto.getApproveActive()));
        }
        if ((list = this.selectList(criterionList)).size() > 0) {
            return (InvoiceTemplate)list.get(0);
        }
        return null;
    }
}

