/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.org;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.contractor.dto.UserCompanyDto;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.Company;
import com.bcxin.risk.org.domain.CompanyDao;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="companyDao")
public class CompanyDaoImpl
extends DaoImpl<Company>
implements CompanyDao {
    public Company findCompanyByOid(Long oid) {
        return (Company)this.selectById(oid);
    }

    public List<Company> findCompanyList(UserCompanyDto userDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (userDto.getAuditActive() != null) {
            criterionList.add(Restrictions.eq((String)"auditactive", (Object)userDto.getAuditActive()));
        }
        if (StringUtil.isNotEmpty((String)userDto.getName())) {
            criterionList.add(Restrictions.eq((String)"name", (Object)userDto.getName()));
        }
        if (StringUtil.isNotEmpty((String)userDto.getUserName())) {
            criterionList.add(Restrictions.eq((String)"userName", (Object)userDto.getUserName()));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public Company findCompanyByOid(long oid) {
        return (Company)this.selectById(oid);
    }

    public Company findCompanyByName(String name) {
        List list = this.selectList(CriterionWrapper.instance().eq("name", (Object)name));
        if (list != null && list.size() > 0) {
            return (Company)list.get(0);
        }
        return null;
    }
}

