/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.order;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.order.OrderForm;
import com.bcxin.risk.order.Transaction;
import com.bcxin.risk.order.TransactionDao;
import com.bcxin.risk.order.dto.TransactionDataDto;
import com.bcxin.risk.order.dto.search.TransactionSearchDto;
import com.bcxin.risk.policy.domain.InsurancePolicy;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class TransactionDaoImpl
extends DaoImpl<Transaction>
implements TransactionDao {
    public Transaction findTransactionByOid(Long oid) {
        return (Transaction)this.selectById(oid);
    }

    public Transaction findTransactionByPolicy(InsurancePolicy insurancePolicy) {
        ArrayList criterionList = Lists.newArrayList();
        if (insurancePolicy != null) {
            criterionList.add(Restrictions.eq((String)"insurancePolicy", (Object)insurancePolicy));
        }
        return (Transaction)this.selectOne(criterionList);
    }

    public List<Transaction> findTransactionList(TransactionSearchDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto != null) {
            if (StringUtil.isNotEmpty((String)searchDto.getOrderNo())) {
                criterionList.add(Restrictions.eq((String)"orderNo", (Object)searchDto.getOrderNo()));
            }
            if (searchDto.getOrderForm() != null) {
                criterionList.add(Restrictions.eq((String)"orderForm", (Object)searchDto.getOrderForm()));
            }
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page, null);
    }

    public List<TransactionDataDto> findTransactionByOrderId(Long orderForm_id) {
        String sql = " SELECT b.accountTime AS payTime, b.confirmAmount AS amount, b.payOrg AS org, b.payAccount AS payAccount, b.payVoucher AS payVoucher, '' AS payOrderNo, '' AS product, a.paymentType AS paymentType, a.paymentMode AS  paymentMode  FROM risk_transaction a ,risk_transactionOffline b  WHERE a.oid = b.oid  AND a.orderForm_id = " + orderForm_id + " UNION  SELECT a.endTime AS payTime, a.amount AS amount, '' AS  org, '' AS payAccount, '' AS payVoucher, b.payOrderNo AS payOrderNo, b.product  AS product , b.paymentType AS paymentType , a.paymentMode AS  paymentMode  FROM risk_transaction a ,risk_transactionOnline b  WHERE a.oid = b.oid  AND a.orderForm_id = " + orderForm_id;
        List list = this.queryMaps(sql);
        ArrayList dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map map = result;
            TransactionDataDto dto = new TransactionDataDto(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public Map queryPgbgSubmitConditon(Long orderId) {
        String sql = "SELECT a.activityStatus,b.orderStatus,c.reportStatus,a.oid AS activityId,b.oid AS orderId,c.oid AS reportId,DATE_FORMAT(a.startDate,'%Y-%m-%d %H:%i:%s') AS startDate FROM risk_activity a,risk_orderform b ,risk_report c WHERE a.oid = b.activity_id AND a.oid = c.activity_id ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (orderId != null) {
            sql = sql + "AND b.oid = " + orderId;
        }
        return this.queryMap(sql, (Wrapper)wrapper);
    }

    public Transaction findTransactionByOrder(OrderForm orderForm) {
        List list;
        ArrayList criterionList = Lists.newArrayList();
        if (orderForm != null) {
            criterionList.add(Restrictions.eq((String)"orderForm", (Object)orderForm));
            criterionList.add(Restrictions.eq((String)"payStatus", (Object)"1"));
        }
        if ((list = this.selectList(criterionList)) != null && list.size() > 0) {
            return (Transaction)list.get(0);
        }
        return null;
    }

    public Long findTransactionIdByOrder(OrderForm orderForm) {
        Object object;
        String sql = "select oid from risk_transaction ";
        Map map = this.queryMap(sql, SelectWrapper.instance().eq("orderForm_id", (Object)orderForm.getOid()));
        if (map != null && (object = map.get("oid")) != null) {
            return Long.parseLong(object.toString());
        }
        return 0L;
    }

    public void deleteTransaction(Long transactionId) {
        String sql = "delete from risk_transactiononline where oid = " + transactionId;
        String sql2 = "delete from risk_transaction where oid = " + transactionId;
        this.executeSqlUpdate(sql);
        this.executeSqlUpdate(sql2);
    }

    public void deleteorderForm(OrderForm orderForm) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"orderForm", (Object)orderForm));
        List transactionList = this.selectList(criterionList);
        for (Transaction transaction : transactionList) {
            String sql1 = "delete from risk_transactionoffline where oid = " + transaction.getOid();
            String sql2 = "delete from risk_transactiononline where oid = " + transaction.getOid();
            String sql3 = "delete from risk_transaction where oid = " + transaction.getOid();
            this.executeSqlUpdate(sql1);
            this.executeSqlUpdate(sql2);
            this.executeSqlUpdate(sql3);
        }
    }
}

