/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.news;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.news.NewsDao;
import com.bcxin.risk.news.domain.News;
import com.bcxin.risk.news.dto.search.NewsSearchDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="newsDao")
public class NewsDaoImpl
extends DaoImpl<News>
implements NewsDao {
    @Resource
    private BaseDao baseDao;

    public List<News> findNewsList(NewsSearchDTO searchDTO, DwzPage page) {
        ArrayList criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)searchDTO.getNewsType())) {
            criterionList.add(Restrictions.eq((String)"newsType", (Object)searchDTO.getNewsType()));
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getProvinceId())) {
            criterionList.add(Restrictions.eq((String)"provinceId", (Object)searchDTO.getProvinceId()));
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getTitle())) {
            criterionList.add(Restrictions.like((String)"title", (Object)("%" + searchDTO.getTitle() + "%")));
        }
        ArrayList<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.desc((String)"createOn"));
        if (page == null) {
            return this.baseDao.findByCriterion(News.class, (List)criterionList, orderList);
        }
        return this.baseDao.findByCriterionForPage(News.class, (List)criterionList, page, orderList);
    }

    public List<News> findProvinceNewsList(String provinceId) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.or((Criterion)Restrictions.eq((String)"provinceId", (Object)provinceId), (Criterion)Restrictions.eq((String)"provinceId", (Object)"100000")));
        return this.baseDao.findByCriterion(News.class, (List)criterionList);
    }
}

