/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.expert;

import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.enums.ExpertTaskStatusEnum;
import com.bcxin.risk.expert.ExpertOrderPublicDao;
import com.bcxin.risk.expert.domain.ExpertOrderPublic;
import com.bcxin.risk.expert.dto.ExpertOrderPublicDto;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="expertOrderPublicDao")
public class ExpertOrderPublicDaoImpl
extends DaoImpl<ExpertOrderPublic>
implements ExpertOrderPublicDao {
    public List<ExpertOrderPublicDto> findOrderList(ExpertOrderPublicDto searchDto, Page page) {
        List list = Lists.newArrayList();
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DATE_FORMAT(A.createOn,'%Y-%m-%d %H:%i:%s') AS createOn, A.oid, A.activityId, A.reportId, A.taskId, B.`name` as activityName, A.expertSource, A.orderNo, A.orgId, A.taskQuote, A.taskStatus, A.taskType, A.userId, C.realName FROM risk_expertorderform_public A INNER JOIN risk_activity B ON A.activityId = B.oid INNER JOIN risk_se_user C ON A.userId = C.oid INNER JOIN risk_expertuser D on C.oid = D.oid WHERE 1=1 ");
        if (searchDto.getOrgId() != null) {
            sql.append(" and A.orgId=" + searchDto.getOrgId() + " ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getTaskStatus())) {
            sql.append(" and A.taskStatus='" + searchDto.getTaskStatus() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getTaskType())) {
            sql.append(" and A.taskType='" + searchDto.getTaskType() + "' ");
        }
        wrapper.orderBy("A.createOn", false);
        if (page == null) {
            list = this.queryMaps(sql.toString(), (Wrapper)wrapper);
        } else {
            Page pageList = this.queryMapsPage(sql.toString(), (Wrapper)wrapper, page);
            list = pageList.getRecords();
        }
        ArrayList<ExpertOrderPublicDto> dtoList = new ArrayList<ExpertOrderPublicDto>();
        list.forEach(result -> {
            ExpertOrderPublicDto dto = new ExpertOrderPublicDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public ExpertOrderPublic findExpertByIdWithActivity(Long activityId, Long expertId, String taskType) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"activityId", (Object)activityId));
        criterionList.add(Restrictions.eq((String)"userId", (Object)expertId));
        criterionList.add(Restrictions.eq((String)"taskType", (Object)taskType));
        List list = this.selectList(criterionList);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (ExpertOrderPublic)list.get(0);
    }

    public void updateStatusToCancel(Long activityId, String taskType, String taskStatus) {
        String sql = "update risk_expertorderform_public set taskStatus='" + taskStatus + "' ";
        sql = sql + " where activityId=" + activityId + " and taskType='" + taskType + "'";
        sql = sql + " and taskStatus in ('" + ExpertTaskStatusEnum.UN_ACCEPT.getKey() + "','" + ExpertTaskStatusEnum.REFUSE.getKey() + "')";
        this.executeSqlUpdate(sql);
    }

    public void updateStatus(Long activityId, Long expertId, String taskType, String taskStatus) {
        String sql = "update risk_expertorderform_public set taskStatus='" + taskStatus + "' ";
        sql = sql + " where activityId=" + activityId + " and taskType='" + taskType + "'";
        sql = sql + " and userId=" + expertId;
        int num = this.executeSqlUpdate(sql);
    }

    public int selectOrderCountByExpertId(Long userId, String taskType, String taskStatus) {
        ArrayList criterionList = Lists.newArrayList();
        ArrayList<String> listStatus = new ArrayList<String>();
        listStatus.add(ExpertTaskStatusEnum.ACCEPT.getKey());
        listStatus.add(ExpertTaskStatusEnum.FINISH.getKey());
        criterionList.add(Restrictions.in((String)"taskStatus", listStatus));
        if (StringUtil.isNotEmpty((String)taskStatus)) {
            criterionList.add(Restrictions.eq((String)"taskStatus", (Object)taskStatus));
        }
        criterionList.add(Restrictions.eq((String)"userId", (Object)userId));
        criterionList.add(Restrictions.eq((String)"taskType", (Object)taskType));
        List list = this.selectList(criterionList);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return 0;
        }
        return list.size();
    }
}

