/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.compose.source;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.compose.dto.search.ComposeVenueSearchDto;
import com.bcxin.risk.compose.source.VenueBase;
import com.bcxin.risk.compose.source.VenueBaseDao;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class VenueBaseDaoImpl
extends DaoImpl<VenueBase>
implements VenueBaseDao {
    @Autowired
    private BaseDao baseDao;

    public List<VenueBase> queryVenueList(ComposeVenueSearchDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)searchDto.getVenueType())) {
            criterionList.add(Restrictions.eq((String)"venueType", (Object)searchDto.getVenueType()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvince())) {
            criterionList.add(Restrictions.eq((String)"province", (Object)searchDto.getProvince()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCity())) {
            criterionList.add(Restrictions.eq((String)"city", (Object)searchDto.getCity()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getName())) {
            criterionList.add(Restrictions.like((String)"name", (Object)("%" + searchDto.getName() + "%")));
        }
        Disjunction dis = Restrictions.disjunction();
        Conjunction con = Restrictions.conjunction();
        dis.add((Criterion)Restrictions.eq((String)"nature", (Object)"0"));
        con.add((Criterion)Restrictions.eq((String)"nature", (Object)"1"));
        con.add((Criterion)Restrictions.eq((String)"userId", (Object)searchDto.getUserId()));
        dis.add((Criterion)con);
        criterionList.add(dis);
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public List<VenueBase> queryVenueListBySql(ComposeVenueSearchDto searchDto, Page page) {
        List list;
        StringBuffer sql = new StringBuffer("select vb.oid,vb.`name`,vb.province,sr1.province as 'provinceName',vb.city,sr2.city as 'cityName',vb.phone,vb.venueAddress,vb.nature,vb.parentId,vb.userId,vb.venueType from venue_base vb");
        sql.append(" LEFT JOIN sys_region sr1 on vb.province = sr1.oid");
        sql.append(" LEFT JOIN sys_region sr2 on vb.city = sr2.oid");
        sql.append(" where 1=1");
        if (StringUtil.isNotEmpty((String)searchDto.getVenueType())) {
            sql.append(" and vb.venueType='" + searchDto.getVenueType() + "'");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvince())) {
            sql.append(" and vb.province='" + searchDto.getProvince() + "'");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCity())) {
            sql.append(" and vb.city='" + searchDto.getCity() + "'");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getName())) {
            sql.append(" and vb.name like'%" + searchDto.getName() + "%'");
        }
        sql.append(" and (vb.nature='0' or (vb.nature='1' and vb.userId='" + searchDto.getUserId() + "'))");
        if (page != null) {
            list = this.baseDao.findBySQL(sql.toString(), null);
            page.setTotal(list.size());
            sql.append(" limit " + page.getSize() * (page.getCurrent() - 1) + "," + page.getSize());
        }
        list = this.baseDao.findBySQL(sql.toString(), null);
        return list;
    }

    public VenueBase findVenue(VenueBase venueBase) {
        List list;
        ArrayList criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)venueBase.getVenueType())) {
            criterionList.add(Restrictions.eq((String)"venueType", (Object)venueBase.getVenueType()));
        }
        if (StringUtil.isNotEmpty((String)venueBase.getProvince())) {
            criterionList.add(Restrictions.eq((String)"province", (Object)venueBase.getProvince()));
        }
        if (StringUtil.isNotEmpty((String)venueBase.getCity())) {
            criterionList.add(Restrictions.eq((String)"city", (Object)venueBase.getCity()));
        }
        if (StringUtil.isNotEmpty((String)venueBase.getName())) {
            criterionList.add(Restrictions.eq((String)"name", (Object)venueBase.getName()));
        }
        if ((list = this.selectList(criterionList)) != null && list.size() > 0) {
            return (VenueBase)list.get(0);
        }
        return null;
    }

    public List<VenueBase> getVenueByType(ComposeVenueSearchDto searchDto) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getUserId() != null) {
            criterionList.add(Restrictions.eq((String)"userId", (Object)searchDto.getUserId()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getVenueType())) {
            criterionList.add(Restrictions.eq((String)"venueType", (Object)searchDto.getVenueType()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getNature())) {
            criterionList.add(Restrictions.eq((String)"nature", (Object)searchDto.getNature()));
        }
        return this.selectList(criterionList);
    }
}

