/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.compose.draft;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.compose.draft.ComposeFrame;
import com.bcxin.risk.compose.draft.ComposeFrameDao;
import com.bcxin.risk.compose.dto.data.ComposeFrameDataDto;
import com.bcxin.risk.compose.dto.search.ComposeFrameSearchDTO;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class ComposeFrameDaoImpl
extends DaoImpl<ComposeFrame>
implements ComposeFrameDao {
    public ComposeFrame findById(long id) {
        return (ComposeFrame)this.selectById(id);
    }

    public List<ComposeFrame> findFrameListByOrg(ComposeFrameSearchDTO searchDTO) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if (searchDTO.getIsShareTemplate().booleanValue()) {
            wrapper.or("(nature = 0 or (nature = 1 and org_id = " + Long.parseLong(searchDTO.getOrg_id()) + "))", null);
        } else {
            wrapper.eq("nature", (Object)"1");
            wrapper.eq("org_id", (Object)Long.parseLong(searchDTO.getOrg_id()));
        }
        if (StringUtil.isNotEmpty((String)searchDTO.getType())) {
            wrapper.eq("type", (Object)searchDTO.getType());
        }
        wrapper.eq("active", (Object)"1");
        return this.selectList((Wrapper)wrapper);
    }

    public List<ComposeFrameDataDto> queryComposeFrameList(ComposeFrameSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT oid, createOn, type, name, active, comment,  nature,  fileUrl  FROM risk_ComposeFrame  where active = 1";
        if (StringUtil.isNotEmpty((String)searchDto.getKeyword())) {
            sql = sql + " and name like '%" + searchDto.getKeyword() + "%'";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getType())) {
            sql = sql + " and type = '" + searchDto.getType() + "'";
        }
        sql = searchDto.getIsShareTemplate() != false ? sql + " and ( nature = 0 or (nature = 1 and org_id = " + Long.parseLong(searchDto.getOrg_id()) + ") )" : sql + " and ( nature = 1 and org_id = " + Long.parseLong(searchDto.getOrg_id()) + " )";
        sql = sql + " order by createOn desc";
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            ComposeFrameDataDto dto = new ComposeFrameDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<Map<String, Object>> ListManageComposeFrame(DwzPage page, ComposeFrameSearchDTO dto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT * FROM risk_composeframe WHERE nature = '0' AND ISNULL(org_id) ";
        if (StringUtil.isNotEmpty((String)dto.getType())) {
            sql = sql + " and type = '" + dto.getType() + "' ";
        }
        if (StringUtil.isNotEmpty((String)dto.getActive())) {
            sql = sql + " and active = '" + dto.getActive() + "' ";
        }
        sql = sql + " ORDER BY oid DESC ";
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return this.queryMaps(sql, (Wrapper)wrapper);
    }
}

