/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.compose.draft;

import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.compose.draft.ComposeFile;
import com.bcxin.risk.compose.draft.ComposeFileDao;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.domain.Report;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class ComposeFileDaoImpl
extends DaoImpl<ComposeFile>
implements ComposeFileDao {
    public ComposeFile findById(long id) {
        return (ComposeFile)this.selectById(id);
    }

    public ComposeFile findByReportAndLevel(long reportId, String composeFileLevel) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("report_id", (Object)reportId);
        wrapper.eq("level", (Object)composeFileLevel);
        List list = this.selectList((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (ComposeFile)list.get(0);
    }

    public ComposeFile findByReportAndTask(long reportId, Long taskId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("report_id", (Object)reportId);
        wrapper.eq("composeTask_id", (Object)taskId);
        List list = this.selectList((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (ComposeFile)list.get(0);
    }

    public ComposeFile findByReportAndTaskId(long reportId, long taskId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("report_id", (Object)reportId);
        wrapper.eq("composeTask_id", (Object)taskId);
        List list = this.selectList((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (ComposeFile)list.get(0);
    }

    public List<ComposeFile> findFrameListByReport(Report report) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("report_id", (Object)report.getOid());
        wrapper.orderBy("oid", false);
        return this.selectList((Wrapper)wrapper);
    }

    public ComposeFile newestComposeFile(Report report) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("report_id", (Object)report.getOid());
        wrapper.orderBy("oid", false);
        List list = this.selectList((Wrapper)wrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return (ComposeFile)list.get(0);
        }
        return null;
    }

    public ComposeFile findByComposeTaskId(long id) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("composeTask_id", (Object)id);
        List list = this.selectList((Wrapper)wrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return (ComposeFile)list.get(0);
        }
        return null;
    }

    public ComposeFile findByFileUrl(String fileUrl) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("fileUrl", (Object)fileUrl);
        List list = this.selectList((Wrapper)wrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return (ComposeFile)list.get(0);
        }
        return null;
    }
}

