/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.dao;

import com.bcxin.risk.activity.dto.data.ActivityDataDTO;
import com.bcxin.risk.base.dao.BaseDaoImpl;
import com.bcxin.risk.base.dao.QueryHelper;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.dao.ScheduleDao;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository(value="scheduleDao")
public class ScheduleDaoImpl
extends BaseDaoImpl
implements ScheduleDao {
    public List<String> findNeedEndReport() {
        HashMap paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder("SELECT a.oid      FROM risk_activity a     inner join risk_orderForm o on o.activity_id = a.oid    WHERE SYSDATE() > a.endDate      AND a.activityStatus != '50'     and o.orderStatus != 1 ");
        ArrayList resultList = Lists.newArrayList();
        List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
        for (Object object : list) {
            Map result = (Map)object;
            resultList.add(result.get("oid") == null ? "" : result.get("oid").toString());
        }
        return resultList;
    }

    public List<String> findNeedEndReport(Long reportId) {
        HashMap paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder("SELECT a.oid FROM risk_activity a  inner join RISK_ActivityRecord r on r.activity_id = a.oid  inner join risk_activityrecord rr on rr.activity_id = a.oid  where 1=1 and endDate < sysdate() and a.activityStatus != '50' ");
        if (reportId == 0L) {
            return Lists.newArrayList();
        }
        sql.append(" and a.oid = :ooid");
        paramMap.put("ooid", reportId);
        sql.append(" and r.activitySubStep = :subStep");
        sql.append(" and rr.activitySubStep = :subStep2");
        paramMap.put("subStep", "50");
        paramMap.put("subStep2", "55");
        ArrayList resultList = Lists.newArrayList();
        List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
        for (Object object : list) {
            Map result = (Map)object;
            resultList.add(result.get("oid") == null ? "" : result.get("oid").toString());
        }
        return resultList;
    }

    public List<ActivityDataDTO> findNeedCompleteContract() {
        HashMap paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder("SELECT a.oid,a.name,a.startDate,a.user_id as userId   FROM risk_activity a ,risk_orderForm b  WHERE a.oid = b.activity_id    AND b.orderStatus = '1'    AND a.startDate >= DATE_ADD(sysdate() , interval 6 day)     AND a.startDate <= DATE_ADD(sysdate() , interval 8 day)    AND EXISTS (SELECT 1                  FROM risk_activity_cooper c ,risk_serviceorg d                 WHERE c.org_id = d.oid                   AND d.serviceOrgType = '1'                   AND c.activity_id = a.oid)    AND NOT EXISTS (SELECT 1                       FROM risk_contract                     WHERE activity_id = a.oid                       AND active = '1')");
        ArrayList resultList = Lists.newArrayList();
        List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
        for (Object object : list) {
            Map result = (Map)object;
            ActivityDataDTO dto = new ActivityDataDTO(result);
            resultList.add(dto);
        }
        return resultList;
    }

    public Map<String, String> countContractByActivity(String activityId) {
        HashMap paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder("SELECT count(oid) as countContract FROM risk_contract where 1=1 ");
        if (StringUtil.isEmpty((String)activityId)) {
            return Maps.newHashMap();
        }
        sql.append(" and activity_id = :reportId");
        paramMap.put("reportId", Long.parseLong(activityId));
        HashMap map = Maps.newHashMap();
        List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
        for (Object object : list) {
            Map result = (Map)object;
            map.put("countContract", result.get("countContract").toString());
        }
        return map;
    }

    public Map<String, String> countCooperByReport(String activityId) {
        HashMap paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder("SELECT count(oid) as countCooper FROM RISK_Activity_Cooper where 1=1 ");
        if (StringUtil.isEmpty((String)activityId)) {
            return Maps.newHashMap();
        }
        sql.append(" and activity_id = :activityId");
        paramMap.put("activityId", Long.parseLong(activityId));
        HashMap map = Maps.newHashMap();
        List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
        for (Object object : list) {
            Map result = (Map)object;
            map.put("countCooper", result.get("countCooper").toString());
        }
        return map;
    }

    public List<String> findNeedFixAddress() {
        HashMap paramMap = Maps.newHashMap();
        StringBuffer sql = new StringBuffer("select oid from risk_report where createOn > DATE_SUB(sysdate() , interval 1 day) and  createOn < sysdate() and oid not in ( select r.oid from risk_report_dedecmsaddress rd inner join risk_reportextra e on rd.reportExtraId = e.oid inner join risk_report r on r.oid = e.reportId where r.createOn > DATE_SUB(sysdate() , interval 1 day)  and  r.createOn < sysdate() ) ");
        ArrayList resultList = Lists.newArrayList();
        List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
        for (Object object : list) {
            Map result = (Map)object;
            String temp = result.get("oid") == null ? "" : result.get("oid").toString();
            resultList.add(temp);
        }
        if (CollectionUtil.isNotEmpty((Collection)resultList)) {
            HashMap paramMap2 = Maps.newHashMap();
            StringBuffer sql2 = new StringBuffer("select e.oid,d.address from risk_report r inner join risk_reportextra e on e.reportId = r.oid  inner join risk_reportdetail d on d.reportId = r.oid ");
            ArrayList resultList2 = Lists.newArrayList();
            List<Object> list2 = QueryHelper.findBySql(sql2.toString(), paramMap2);
            for (Object object : list2) {
                Map result = (Map)object;
                String temp = result.get("oid") == null ? "" : result.get("oid").toString();
                String temp2 = result.get("address") == null ? "" : result.get("address").toString();
                resultList.add(temp);
            }
        }
        return resultList;
    }
}

