/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.activity;

import com.bcxin.risk.activity.Quotation;
import com.bcxin.risk.activity.QuotationFactor;
import com.bcxin.risk.activity.QuotationFactorDao;
import com.bcxin.risk.activity.dto.search.QuotationSearchDTO;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.Org;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class QuotationFactorDaoImpl
extends DaoImpl<QuotationFactor>
implements QuotationFactorDao {
    public List<QuotationFactor> selectList() {
        ArrayList criterionList = Lists.newArrayList();
        return this.selectList(criterionList);
    }

    public QuotationFactor findQuotationFactorByOid(Long oid) {
        return (QuotationFactor)this.selectById(oid);
    }

    public QuotationFactor findQuotationFactorByDto(QuotationSearchDTO searchDto) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getOrg() != null) {
            criterionList.add(Restrictions.eq((String)"org", (Object)searchDto.getOrg()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActive())) {
            criterionList.add(Restrictions.eq((String)"active", (Object)searchDto.getActive()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPriceType())) {
            criterionList.add(Restrictions.eq((String)"priceType", (Object)searchDto.getPriceType()));
        }
        return (QuotationFactor)this.selectOne(criterionList);
    }

    public QuotationFactor findFactorByQuotation(Quotation quotation) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"quotation", (Object)quotation));
        return (QuotationFactor)this.selectOne(criterionList);
    }

    public Map<String, Object> findFactorByRegion(Org org, String cityId, String areaId) {
        String sql = " select f.*,q.quotationType from risk_quotationfactor f \n inner join risk_quotation q on q.oid = f.quotation_id and q.active=1\n inner join risk_quotationregion r on r.quotation_id = q.oid ";
        if (StringUtil.isEmpty((String)areaId)) {
            SelectWrapper wrapper = SelectWrapper.instance();
            wrapper.eq("q.org_id", (Object)org.getOid());
            wrapper.eq("r.region_Id", (Object)cityId);
            List result = this.queryMaps(sql, (Wrapper)wrapper);
            if (CollectionUtil.isNotEmpty((Collection)result)) {
                return (Map)result.get(0);
            }
            return Maps.newHashMap();
        }
        SelectWrapper wrapper2 = SelectWrapper.instance();
        wrapper2.eq("q.org_id", (Object)org.getOid());
        wrapper2.eq("r.region_Id", (Object)cityId);
        List result2 = this.queryMaps(sql, (Wrapper)wrapper2);
        if (CollectionUtil.isNotEmpty((Collection)result2)) {
            return (Map)result2.get(0);
        }
        return Maps.newHashMap();
    }
}

