/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.activity;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.ActivityCooper;
import com.bcxin.risk.activity.ActivityCooperDao;
import com.bcxin.risk.activity.ActivityDao;
import com.bcxin.risk.activity.dto.data.ActivityCooperDTO;
import com.bcxin.risk.base.domain.util.LongUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.dto.search.CooperSearchDTO;
import com.bcxin.risk.hibernateplus.condition.DeleteWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityCooperDaoImpl
extends DaoImpl<ActivityCooper>
implements ActivityCooperDao {
    @Autowired
    private ActivityDao activityDao;

    public ActivityCooper findActivityCooperByOid(Long oid) {
        return (ActivityCooper)this.selectById(oid);
    }

    public void deleteByActivity(Activity activity) {
        this.delete(DeleteWrapper.instance().eq("activity_id", (Object)activity.getOid()));
    }

    public void deleteByActivityCooperBags(String activityNo) {
        String sql = "delete t1 from risk_activity_cooper t1  inner join risk_activity t2 on t1.activity_Id = t2.oid  inner join risk_org t3 on t1.org_Id = t3.saasComid  inner join risk_serviceorg t4 on t4.oid = t3.oid  where t2.activityNo = '" + activityNo + "' and t4.serviceOrgType = 5";
        this.executeSqlUpdate(sql);
    }

    public List<ActivityCooperDTO> findActivityCooperDtoByActivty(Activity activity) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer("select o.oid,o.name,so.serviceOrgType,so.contactPhone,so.contactName ,rcp.amount,rcp.oid as rcpoid,so.financePhone, so.distributionorg as distributionorg ,a.oid AS orderId,o.oid AS orgId  from RISK_ACTIVITY_COOPER rcp  inner join RISK_ACTIVITY r on r.oid = rcp.activity_id  inner join RISK_ORG o on o.oid = rcp.org_Id  inner join RISK_ORDERFORM a on a.activity_id = r.oid  inner join RISK_SERVICEORG so on so.oid = o.oid ");
        if (activity == null) {
            return Lists.newArrayList();
        }
        wrapper.eq("r.oid", (Object)activity.getOid());
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql.toString(), (Wrapper)wrapper);
        list.forEach(result -> {
            Map map = result;
            ActivityCooperDTO dto = new ActivityCooperDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<ActivityCooperDTO> findActivityCooperDto(CooperSearchDTO searchDto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select o.oid,o.name,so.serviceOrgType,so.contactPhone,so.contactName,so.minQuote from RISK_ORG o inner join RISK_SERVICEORG so on so.oid = o.oid ";
        if (searchDto == null) {
            return Lists.newArrayList();
        }
        if (LongUtil.isNotEmpty((Long)searchDto.getActivity_id())) {
            Activity activity = this.activityDao.findActivityByOid(searchDto.getActivity_id());
            sql = activity.getCity() != null ? sql + " inner join risk_org_region a on a.org_id = o.oid AND a.region_level = '2' AND a.region_id = " + activity.getCity().getOid() + " " : sql + " inner join risk_org_region a on a.org_id = o.oid AND a.region_level = '1' AND a.region_id = " + activity.getProvince().getOid() + " ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getType())) {
            wrapper.eq("so.serviceOrgType", (Object)searchDto.getType());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getName())) {
            wrapper.like("o.name", searchDto.getName());
        }
        if (searchDto.getOids() != null && searchDto.getOids().length > 0) {
            wrapper.in("o.oid", (Object[])searchDto.getOids());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getApprovalStatus())) {
            wrapper.eq("so.approvalStatus", (Object)searchDto.getApprovalStatus());
        }
        if (searchDto.getActivity() != null) {
            sql = sql + " inner join " + "RISK_ACTIVITY_COOPER" + " ac on ac.org_id = o.oid ";
            wrapper.eq("ac.activity_id", (Object)searchDto.getActivity().getOid());
        }
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        list.forEach(result -> {
            ActivityCooperDTO dto = new ActivityCooperDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<ActivityCooperDTO> findAssessmentCooperDTOAndOrder(CooperSearchDTO searchDto) {
        if (searchDto == null) {
            return Lists.newArrayList();
        }
        Activity activity = this.activityDao.findActivityByOid(searchDto.getActivity_id());
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct o.oid,o.name,so.serviceOrgType,so.contactPhone,so.contactName,so.minQuote,so.serviceMode  from risk_org o inner join RISK_SERVICEORG so on so.oid = o.oid  inner join risk_quotation q on q.org_id = o.oid  inner join risk_quotationregion qr on qr.quotation_id = q.oid  INNER JOIN risk_se_user u ON u.org_id = o.oid ");
        if (activity.getCity() != null) {
            sql.append(" inner join risk_org_region a on a.org_id = o.oid AND a.region_level = '2' AND a.region_id = " + activity.getCity().getOid());
        } else {
            sql.append(" inner join risk_org_region a on a.org_id = o.oid AND a.region_level = '1' AND a.region_id = " + activity.getProvince().getOid());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getType())) {
            sql.append(" AND so.serviceOrgType = '" + searchDto.getType() + "'");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getName())) {
            sql.append(" AND so.serviceOrgType like '%" + searchDto.getName() + "%'");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getApprovalStatus())) {
            sql.append(" AND so.approvalStatus = '" + searchDto.getApprovalStatus() + "'");
        }
        sql.append(" and (qr.region_Id = " + searchDto.getCity_id() + " or qr.region_Id = " + searchDto.getArea_id() + ")");
        sql.append(" order by so.serviceMode");
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql.toString(), (Wrapper)wrapper);
        list.forEach(result -> {
            Map map = result;
            ActivityCooperDTO dto = new ActivityCooperDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public ActivityCooperDTO findAssessmentCooperByActivity(CooperSearchDTO searchDto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select o.ywzcId, o.oid,o.name,so.serviceOrgType,so.contactPhone,so.contactName,c.oid as cooperOid ,d.oid AS orderId ,so.umpayMerId,so.boofooMerId,d.amount,so.stampedPicture,so.approvalStatus,so.business_license_num  from RISK_ORG o inner join RISK_SERVICEORG so on so.oid = o.oid  inner join RISK_ACTIVITY_COOPER c on c.org_id = o.oid  inner join RISK_ORDERFORM d on d.activity_id = c.activity_id ";
        if (searchDto == null) {
            return new ActivityCooperDTO();
        }
        if (searchDto.getActivity() != null) {
            wrapper.eq("c.activity_id", (Object)(searchDto.getActivity().getOid() + ""));
        }
        if (LongUtil.isNotEmpty((Long)searchDto.getActivity_id())) {
            wrapper.eq("c.activity_id", (Object)(searchDto.getActivity_id() + ""));
        }
        if (LongUtil.isNotEmpty((Long)searchDto.getOrder_id())) {
            wrapper.eq("d.oid", (Object)(searchDto.getOrder_id() + ""));
        }
        wrapper.eq("so.serviceOrgType", (Object)"1");
        Map map = this.queryMap(sql, (Wrapper)wrapper);
        if (map == null) {
            return new ActivityCooperDTO();
        }
        return new ActivityCooperDTO(map);
    }

    public ActivityCooperDTO findSimpleAssessmentByActivity(Activity activity) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select o.oid,o.name,so.serviceMode from RISK_ORG o inner join RISK_SERVICEORG so on so.oid = o.oid  inner join RISK_ACTIVITY_COOPER c on c.org_id = o.oid ";
        wrapper.eq("c.activity_id", (Object)activity.getOid());
        wrapper.eq("so.serviceOrgType", (Object)"1");
        Map map = this.queryMap(sql, (Wrapper)wrapper);
        if (map == null) {
            return new ActivityCooperDTO();
        }
        return new ActivityCooperDTO(map);
    }
}

