package com.bcxin.oa.old.service.task;

import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.mapper.ComTaskAttendAddressMapper;
import com.bcxin.oa.old.mapper.ComTaskFixedMapper;
import com.bcxin.oa.old.mapper.ComTaskMapper;
import com.bcxin.oa.old.entity.task.ComTask;
import com.bcxin.oa.old.entity.task.ComTaskAttendAddress;
import com.bcxin.oa.old.entity.task.ComTaskFixed;
import com.bcxin.oa.old.dto.ComTaskFixedDTO;
import com.bcxin.oa.old.dto.ComTaskFixedTempDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.common.CommonService;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.DictConst;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 任务固定班制明细
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
@Service
@Transactional
public class ComTaskFixedServiceImpl implements ComTaskFixedService {
	@Resource
	private ComTaskFixedMapper comTaskFixedMapper;
	@Resource
	private ComTaskMapper comTaskMapper;
	@Resource
	private ComTaskAttendAddressMapper comTaskAttendAddressMapper;
	@Resource
	private CommonService commonService;
	@Resource
	private IdWorker idWorker;

	@Override
	public Result save(ComTaskFixedTempDTO comTaskFixedTempDTO) throws BusinessException {
		Long taskId = comTaskFixedTempDTO.getComTaskId();// 任务ID
		if (taskId == null) {
			throw new BusinessException(Result.ERROR, "任务ID为空");
		}
		// 查找考勤组ID是否存在,如果存在则修改考勤类型
		ComTask comTask = comTaskMapper.getByPrimaryKey(taskId);
		if (comTask == null) {
			throw new BusinessException(Result.ERROR, "任务不存在");
		}
		// 固定排班制以String格式传上来
		// 修改："comTaskFixeds":{ "taskFixedId":"397846222926249984",
		// "weekDay":"1","shiftId":"1"｝,{ "taskFixedId":"397846222926249983",
		// "weekDay":"2","shiftId":"2"｝...
		// 新增："comTaskFixeds":{ "taskFixedId":"", "weekDay":"1","shiftId":"1"｝,{
		// "taskFixedId":"", "weekDay":"2","shiftId":"2"｝...
		List<ComTaskFixed> list = JSON.parseArray(comTaskFixedTempDTO.getComTaskFixeds(), ComTaskFixed.class);
		if (list.size() == 7) {// 如果size不是7就说明上传少（多）了几天
			for (ComTaskFixed comTaskFixed : list) {
				// 设置工作id
				comTaskFixed.setComTaskId(taskId);
				// 工作日+shiftId+（shiftId不为空则isRect为0否则为1）
				comTaskFixed.setIsRest(
						comTaskFixed.getShiftId() != null ? DictConst.DATAAUTHFLAG_F : DictConst.DATAAUTHFLAG_S);
				if (comTaskFixed.getTaskFixedId() != null) {
					// 修改
					if (comTaskFixedMapper.update(comTaskFixed) == 0) {
						throw new BusinessException(Result.ERROR, "修改任务固定班次失败");
					}
				} else {
					comTaskFixed.setTaskFixedId(idWorker.nextId());
					comTaskFixed.setIsDelete(DictConst.DATAAUTHFLAG_F);
					// 新增
					if (comTaskFixedMapper.insert(comTaskFixed) == 0) {
						throw new BusinessException(Result.ERROR, "新增任务固定班次失败");
					}

				}
			}
		}
		// 任务出勤地点列表以String格式传上来
		// 修改："comTaskAttendAdresses":{
		// "taskAttendAddressId":"397843933108895744",
		// "address":"软件园二期30号","addressLongitude":"110.3","addressLatitude":"133.4","addressRange":"1000"｝
		// 新增："comTaskAttendAdresses":{ "taskAttendAddressId":"",
		// "address":"软件园二期30号","addressLongitude":"110.3","addressLatitude":"133.4","addressRange":"1000"｝
		List<ComTaskAttendAddress> adresseslist = JSON.parseArray(comTaskFixedTempDTO.getComTaskAttendAdresses(),
				ComTaskAttendAddress.class);
		if (adresseslist.size() > 0) {
			for (ComTaskAttendAddress comTaskAttendAddress : adresseslist) {
				// 设置任务id
				comTaskAttendAddress.setComTaskId(taskId);
				if (comTaskAttendAddress.getTaskAttendAddressId() != null) {
					// 修改
					if (comTaskAttendAddressMapper.update(comTaskAttendAddress) == 0) {
						throw new BusinessException(Result.ERROR, "修改出勤地点失败");
					}
				} else {
					comTaskAttendAddress.setTaskAttendAddressId(idWorker.nextId());
					comTaskAttendAddress.setIsDelete(DictConst.DATAAUTHFLAG_F);

					// 新增
					if (comTaskAttendAddressMapper.insert(comTaskAttendAddress) == 0) {
						throw new BusinessException(Result.ERROR, "新增出勤地点失败");
					}

				}
			}

		}

		return Result.success(Result.SUCCESS_MSG);
	}

	@Override
	public Result update(ComTaskFixedTempDTO comTaskFixedTempDTO) throws BusinessException {
		// String comAttendGroupFixeds =
		// comAttendGroupFixedTempDTO.getComAttendGroupFixeds();
		// List<ComAttendGroupFixedDTO> comAttendGroupFixedDTOList = null;
		// if (StringUtils.isEmpty(comAttendGroupFixeds)) {
		// throw new BusinessException(Result.ERROR, "考勤班次为空");
		// } else {
		// comAttendGroupFixedDTOList = JSON.parseArray(comAttendGroupFixeds,
		// ComAttendGroupFixedDTO.class);
		// for (ComAttendGroupFixedDTO comAttendGroupFixedDTO :
		// comAttendGroupFixedDTOList) {
		// comAttendGroupFixedDTO.setUpdateBy(comAttendGroupFixedTempDTO.getUpdateBy());
		// comAttendGroupFixedDTO.setUpdateTime(comAttendGroupFixedTempDTO.getUpdateTime());
		// comAttendGroupFixedMapper.update(comAttendGroupFixedDTO);
		// }
		// }
		return Result.success(Result.SUCCESS_MSG);
	}

	@Override
	public Result getDetail(ComTaskFixedDTO comTaskFixedDTO) throws BusinessException {
		Long taskId = comTaskFixedDTO.getComTaskId();// 任务ID
		if (taskId == null) {
			throw new BusinessException(Result.ERROR, "任务ID为空");
		}
		// 查找考勤组ID是否存在,如果存在则修改考勤类型
		ComTask comTask = comTaskMapper.getByPrimaryKey(taskId);
		if (comTask == null) {
			throw new BusinessException(Result.ERROR, "任务不存在");
		}
		ComTaskFixedTempDTO comTaskFixedTempDTO = new ComTaskFixedTempDTO();
		comTaskFixedTempDTO.setComTaskId(taskId);
		comTaskFixedTempDTO.setAttendType(comTask.getAttendType());
		List<ComTaskFixedDTO> comTaskFixedDTOList = new ArrayList<ComTaskFixedDTO>();
		// 根据任务id获取固定排班制信息
		List<ComTaskFixed> comAttendGroupFixedList = comTaskFixedMapper.list(comTaskFixedDTO);
		if (comAttendGroupFixedList != null && comAttendGroupFixedList.size() > 0) {
			for (ComTaskFixed comTaskFixed : comAttendGroupFixedList) {
				ComTaskFixedDTO comTaskFixedReturnDTO = new ComTaskFixedDTO();
				ObjectUtils.copyProperties(comTaskFixedReturnDTO, comTaskFixed);
				Long shiftId = comTaskFixed.getShiftId();
				comTaskFixedReturnDTO.setShiftDetails(commonService.listChangeToString(shiftId, true, true));
				comTaskFixedDTOList.add(comTaskFixedReturnDTO);
			}
		}
		// 根据任务id获取考勤地点
		comTaskFixedTempDTO
				.setReturnComTaskAttendAddressList(comTaskAttendAddressMapper.listComTaskAttendAddress(taskId));
		comTaskFixedTempDTO.setReturnComTaskFixedDList(comTaskFixedDTOList);
		return Result.success(Result.SUCCESS_QUERY_MSG, comTaskFixedTempDTO);
	}

	@Override
	public Result getAddTemp(ComTaskFixedDTO comTaskFixedDTO) throws BusinessException {
		List<ComTaskFixedDTO> comTaskFixedDTOList = new ArrayList<ComTaskFixedDTO>();
		for (int i = 1; i < 8; i++) {
			ComTaskFixedDTO comTaskFixedTempDTOTemp = new ComTaskFixedDTO();
			comTaskFixedTempDTOTemp.setWeekDay(i);
			comTaskFixedTempDTOTemp.setIsRest(CommonConst.Y);
			comTaskFixedDTOList.add(comTaskFixedTempDTOTemp);
		}
		return Result.success(Result.SUCCESS_QUERY_MSG, comTaskFixedDTOList);
	}
}