
package com.bcxin.oa.old.service.system;

import cn.hutool.core.util.ObjectUtil;
import com.bcxin.oa.old.common.*;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.ExcelUtil;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.dto.*;
import com.bcxin.oa.old.entity.enterprise.company.ComBaseInfo;
import com.bcxin.oa.old.entity.system.ComDepart;
import com.bcxin.oa.old.entity.system.PerOrgRelation;
import com.bcxin.oa.old.mapper.ComBaseInfoMapper;
import com.bcxin.oa.old.mapper.ComDepartMapper;
import com.bcxin.oa.old.mapper.PerBaseInfoMapper;
import com.bcxin.oa.old.mapper.PerOrgRelationMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 部门
 *
 * @author zhangye
 * @since 2017-12-22 10:37:19
 */
@Service
@Transactional
public class ComDepartServiceImpl implements ComDepartService {
    @Resource
    private ComDepartMapper comDepartMapper;
    @Resource
    private PerOrgRelationMapper perOrgRelationMapper;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;
    @Autowired
    public CacheService cacheService;
    @Resource
    private PerOrgRelationService perOrgRelationService;

    @Override
    public Result selecteByParentDepartId(ComDepartDto comDepart) {
        String keyword = comDepart.getKeyword();
        List<ComDepart> list = comDepartMapper.selecteByParentDepartId(comDepart.getParentDepartId(),
                comDepart.getComId(), keyword);
        List<ComDepartDto> list1 = new ArrayList<ComDepartDto>();
        if (StringUtils.isEmpty(keyword)) {
            // 没有关键字
            if (comDepart.getParentDepartId() == -1) {
                ComBaseInfo comBaseInfo = comBaseInfoMapper.getByPrimaryKey(comDepart.getComId());
                ComDepartDto comDepart1 = new ComDepartDto();
                // 这个是公司
                comDepart1.setCompanyName(comBaseInfo.getComName());
                comDepart1.setComId(comDepart.getComId());
                comDepart1.setIsDelete(BaseCode.NO);
                int count = comDepartMapper.countForCompany(comDepart.getComId());
                comDepart1.setPersonNumber(count);
            }
        } else {// 有关键字可以查人员
            ComDepartDto comDepartDto = new ComDepartDto();
            List<Map> list2 = perBaseInfoMapper.selectPerBaseInfoByKeword(keyword, comDepart.getComId());
            for (Map p : list2) {
                Long perId = Long.valueOf(String.valueOf(p.get("perId")));
                comDepartDto.setOldPerID(perId);
                PerOrgRelation perOrgRelation = perOrgRelationMapper.getByPerIdAndComId(perId, comDepart.getComId());
                Long orgId = perOrgRelation.getOrgId();
                Long comId = perOrgRelation.getComId();
                if (comId.equals(orgId)) {// 如果这个人是在公司底下，则返回部门id为-1
                    comDepartDto.setDepartId(-1L);
                } else {
                    comDepartDto.setDepartId(orgId);
                }
                comDepartDto.setComId(comId);
                comDepartDto.setOldPerName(String.valueOf(p.get("name")));
                list1.add(comDepartDto);
            }
        }
        for (ComDepart comDepart2 : list) {
            ComDepartDto comDepartDto2 = new ComDepartDto();
            ObjectUtils.copyProperties(comDepartDto2, comDepart2);
            int count = comDepartMapper.countForSelecteByDepartID(comDepart2.getDepartId());
            int countChildDepart = comDepartMapper.countForHaveChildDepart(comDepart2.getDepartId());
            if (countChildDepart > 0) {
                comDepartDto2.setHaveChild(true);
            }
            comDepartDto2.setPersonNumber(count);
            list1.add(comDepartDto2);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, list1);
    }

    @Override
    public Result selecteComAndDepartByParentDepartId(ComDepartDto comDepart) {
        List<ComDepart> list = comDepartMapper.selecteByParentDepartId(comDepart.getParentDepartId(),
                comDepart.getComId(), null);
        List<ComDepartDto> list1 = new ArrayList<ComDepartDto>();
        ComDepartDto comDepart1 = new ComDepartDto();
        // 没有关键字
        if (comDepart.getParentDepartId() == -1) {
            ComBaseInfo comBaseInfo = comBaseInfoMapper.getByPrimaryKey(comDepart.getComId());

            // 这个是公司
            comDepart1.setCompanyName(comBaseInfo.getComName());
            comDepart1.setTitle(comBaseInfo.getComName());
            comDepart1.setComId(comDepart.getComId());
            comDepart1.setHaveChild(true);
            comDepart1.setKey(String.valueOf(comBaseInfo.getComId()));
            comDepart1.setIsDelete(BaseCode.NO);
            int count = comDepartMapper.countForCompany(comDepart.getComId());
            comDepart1.setPersonNumber(count);
        }

        for (ComDepart comDepart2 : list) {
            ComDepartDto comDepartDto2 = new ComDepartDto();
            ObjectUtils.copyProperties(comDepartDto2, comDepart2);
            comDepartDto2.setTitle(comDepartDto2.getDepartName());
            comDepartDto2.setKey(String.valueOf(comDepartDto2.getDepartId()));
            int count = comDepartMapper.countForSelecteByDepartID(comDepart2.getDepartId());
            int countChildDepart = comDepartMapper.countForHaveChildDepart(comDepart2.getDepartId());
            if (countChildDepart > 0) {
                comDepartDto2.setHaveChild(true);
            }
            comDepartDto2.setPersonNumber(count);

            list1.add(comDepartDto2);
        }
        comDepart1.setChildren(list1);
        return Result.success(Result.SUCCESS_QUERY_MSG, comDepart1);
    }

    @Override
    public Result getByPrimaryKey(ComDepartDto comDepartDto) {
        ComDepartDto comDepartDto2 = comDepartMapper.selectChargeByDepartId(comDepartDto.getDepartId());// 找这个部门的主管
        ComDepartDto comDepartDto3 = new ComDepartDto();
        ObjectUtils.copyProperties(comDepartDto3, comDepartMapper.getByPrimaryKey(comDepartDto.getDepartId()));
        if (comDepartDto2 != null) {
            comDepartDto3.setOldPerName(comDepartDto2.getOldPerName());
            comDepartDto3.setOldPerID(comDepartDto2.getOldPerID());
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, comDepartDto3);
    }


    @SuppressWarnings("rawtypes")
    @Override
    public Result getTreePerByDepart(ComDepartDto comDepartDto) {
        Long parentDepartId = -1L;
        Long comId = comDepartDto.getComId();
        List<ComDepartPersonTreeDto> list = new ArrayList<ComDepartPersonTreeDto>();
        // 获取公司信息
        ComBaseInfo comBaseInfo = comBaseInfoMapper.getByPrimaryKey(comId);
        ComDepartPersonTreeDto root = new ComDepartPersonTreeDto();
        root.setTitle(comBaseInfo.getComName());
        root.setKey("-1");
        root.setLabel(comBaseInfo.getComName());
        root.setValue("-1");
        root.setIsLeaf(false);
        root.setTreeType(TreeTypeCode.DEPART);

        Map<String, Object> param = new HashMap<String, Object>();
        param.put("parentDepartId", parentDepartId);
        param.put("limitType", comDepartDto.getLimitType());
        param.put("comId", comId);
        // 根据公司ID、登陆用户ID获取人员数据权限
        List<Map> persons = comDepartMapper.personByComId(comId);
        // 根据公司ID、登陆用户ID获取部门数据权限
        List<Map> allTreeDepart = comDepartMapper.getTreeDepart(comId);
        List<ComDepartPersonTreeDto> childlist = getAllPersonChild(param, persons, allTreeDepart,
                comDepartDto.getCreateBy());
        if (childlist != null && childlist.size() > 0) {
            root.setChildren(childlist);
        }
        list.add(root);
        return Result.success(Result.SUCCESS_QUERY_MSG, list);
    }

    @Override
    public Result getTreePerByDepartMap(ComDepartDto comDepartDto) {
        Long comId = comDepartDto.getComId();
        Map map = Maps.newHashMap();
        List<Map> list = perBaseInfoMapper.selectPerBaseInfoByKeword(null, comId);
        list.forEach(val -> {
            map.put(val.get("perId"), val);
        });
        return Result.success(Result.SUCCESS_QUERY_MSG, map);
    }

    /**
     * 选人公共部门树接口
     *
     * @param comDepartDto
     * @return
     * @update llc
     * @date 2019-08-28
     */
    @Override
    public Result getTreeDepart(ComDepartDto comDepartDto) {
        Long parentDepartId = -1L;
        Long comId = comDepartDto.getComId();
        // 增加顶级公司信息
        List<ComDepartTreeDto> list = new ArrayList<ComDepartTreeDto>();
        ComBaseInfo comBaseInfo = comBaseInfoMapper.getByPrimaryKey(comId);
        ComDepartTreeDto root = new ComDepartTreeDto();
        root.setTitle(comBaseInfo.getComName());
        root.setKey("-1");
        root.setLabel(comBaseInfo.getComName());
        root.setValue("-1");
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("parentDepartId", parentDepartId);
        param.put("comId", comId);
        List<ComDepartTreeDto> childlist = new ArrayList<ComDepartTreeDto>();
        List<Map> allTreeDepart = comDepartMapper.getTreeDepart(comId);// 获取部门列表
        childlist = getAllDepartChild(param, allTreeDepart);
        if (childlist != null && childlist.size() > 0) {
            root.setChildren(childlist);
        }
        list.add(root);
        return Result.success("", list);
    }

    /**
     * @param param
     * @return
     * @descript:递归部门
     */
    @SuppressWarnings("rawtypes")
    private List<ComDepartTreeDto> getAllDepartChild(Map<String, Object> param, List<Map> allTreeDepart) {
        List<ComDepartTreeDto> deptVosList = new ArrayList<ComDepartTreeDto>();
        Long parentDepartId = Long.valueOf(param.get("parentDepartId").toString());
        Long comId = Long.valueOf(param.get("comId").toString());
        if (allTreeDepart != null && allTreeDepart.size() > 0) {
            for (Map map : allTreeDepart) {
                if (parentDepartId.equals(Long.valueOf(map.get("parentDepartId").toString()))) {
                    ComDepartTreeDto comDepartTreeDto = new ComDepartTreeDto();
                    comDepartTreeDto.setKey(String.valueOf(map.get("departId")));
                    comDepartTreeDto.setValue(String.valueOf(map.get("departId")));
                    comDepartTreeDto.setTitle(String.valueOf(map.get("departName")));
                    comDepartTreeDto.setLabel(String.valueOf(map.get("departName")));
                    Map<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("parentDepartId", String.valueOf(map.get("departId")));
                    paramMap.put("comId", comId);
                    comDepartTreeDto.setChildren(getAllDepartChild(paramMap, allTreeDepart));
                    deptVosList.add(comDepartTreeDto);
                }
            }
        }
        return deptVosList;
    }

    /**
     * 获取子部门与部门人员
     */
    @SuppressWarnings("rawtypes")
    private List<ComDepartPersonTreeDto> getAllPersonChild(Map<String, Object> param, List<Map> persons,
                                                           List<Map> allTreeDepart, Long createBy) {
        List<ComDepartPersonTreeDto> deptVosList = new ArrayList<ComDepartPersonTreeDto>();
        Long parentDepartId = Long.valueOf(param.get("parentDepartId").toString());
        Long comId = Long.valueOf(param.get("comId").toString());
        // 获取公司底下人员列表
        if (parentDepartId == -1) {
            // 添加公司下人员
            List<Map> clildrenMap = comDepartMapper.treePersonByComId(comId, OrgTypeCode.COMPANY);
            for (Map person : clildrenMap) {
                ComDepartPersonTreeDto childDepartDto = new ComDepartPersonTreeDto();
                childDepartDto.setTitle(person.get("name") == null ? "无姓名" : person.get("name").toString());
                childDepartDto.setKey(person.get("perId") == null ? null : String.valueOf(person.get("perId")));
                childDepartDto.setLabel(person.get("name") == null ? "无姓名" : person.get("name").toString());
                childDepartDto.setValue(person.get("perId") == null ? null : String.valueOf(person.get("perId")));
                childDepartDto.setMobilePhone(person.get("mobilePhone") == null ? null : String.valueOf(person.get("mobilePhone")));
                childDepartDto.setIdCardNo(person.get("idCardNo") == null ? null : String.valueOf(person.get("idCardNo")));
                childDepartDto.setTreeType(TreeTypeCode.PERSON);
                childDepartDto.setIsLeaf(TreeTypeCode.PERSON_IS_LEAF);
                deptVosList.add(childDepartDto);
            }
        }
        String limitType = null;
        if (param.get("limitType") != null) {
            limitType = String.valueOf(param.get("limitType"));
        }

        // 个人
        if (persons != null && persons.size() > 0) {
            List<Map> deletePersons = new ArrayList<Map>();
            for (Map person : persons) {
                Long departId = person.get("departId") == null ? null : Long.valueOf(person.get("departId").toString());
                if (departId != null && parentDepartId.equals(departId)) {
                    ComDepartPersonTreeDto childDepartDto = new ComDepartPersonTreeDto();
                    childDepartDto.setTitle(person.get("name") == null ? "无姓名" : person.get("name").toString());
                    childDepartDto.setKey(person.get("perId") == null ? null : String.valueOf((person.get("perId"))));
                    childDepartDto.setLabel(person.get("name") == null ? "无姓名" : person.get("name").toString());
                    childDepartDto.setValue(person.get("perId") == null ? null : String.valueOf((person.get("perId"))));
                    childDepartDto.setMobilePhone(person.get("mobilePhone") == null ? null : String.valueOf(person.get("mobilePhone")));
                    childDepartDto.setIdCardNo(person.get("idCardNo") == null ? null : String.valueOf(person.get("idCardNo")));
                    childDepartDto.setTreeType(TreeTypeCode.PERSON);
                    childDepartDto.setIsLeaf(TreeTypeCode.PERSON_IS_LEAF);
                    deptVosList.add(childDepartDto);
                    deletePersons.add(person);
                }
            }
            if (deletePersons != null && deletePersons.size() > 0) {
                persons.removeAll(deletePersons);
            }
        }
        // 部门
        if (allTreeDepart != null && allTreeDepart.size() > 0) {
            List<Map> deleteDeparts = new ArrayList<Map>();
            for (Map map : allTreeDepart) {
                if (parentDepartId.equals(Long.valueOf(map.get("parentDepartId").toString()))) {
                    ComDepartPersonTreeDto comDepartPersonTreeDto = new ComDepartPersonTreeDto();
                    comDepartPersonTreeDto.setKey(String.valueOf(map.get("departId")));
                    comDepartPersonTreeDto.setValue(String.valueOf(map.get("departId")));
                    comDepartPersonTreeDto.setTitle(String.valueOf(map.get("departName")));
                    comDepartPersonTreeDto.setLabel(String.valueOf(map.get("departName")));
                    comDepartPersonTreeDto.setTreeType(TreeTypeCode.DEPART);
                    comDepartPersonTreeDto.setIsLeaf(TreeTypeCode.DEPART_IS_LEAF);

                    Map<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("parentDepartId", String.valueOf(map.get("departId")));
                    paramMap.put("comId", comId);
                    paramMap.put("limitType", limitType);
                    comDepartPersonTreeDto.setChildren(getAllPersonChild(paramMap, persons, allTreeDepart, createBy));
                    deptVosList.add(comDepartPersonTreeDto);
                    deleteDeparts.add(map);
                }
            }
        }

        return deptVosList;
    }

    /**
     * 生成员工信息模板 by llc 2018-09-13
     */

    @Override
    public Result exportDepartTemp(String comId, HttpServletResponse response) throws BusinessException {

        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {

            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;fileName=" + new String("组织架构模板.xls".getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("组织架构模板");
            HSSFSheet sheet2 = wb.createSheet("下拉列表");
            wb.setSheetHidden(1, true);

            /**** excel标题栏 ****/
            String headerTitle = "批量导入人员填写须知：\n" + " <1>请先登录Web端平台（电脑端/PC端）完善部门信息（人事-组织架构）、完善角色信息（人事-角色权限）；\n"
                    + " <2>表单列目中带*号为必填字段，未带*号为非必填字段；\n" + " <3>部门：请下拉选择部门，不可随意输入，若为空，则自动归在企业级下；\n"
                    + " <4>姓名：请填准确姓名信息，不可输入空格或其他特殊符号；\n" + " <5>证件类型：请下拉选择类型，不可随意输入；\n"
                    + " <6>证件号码：请填准确证件号码，若被转化成科学计数格式，请双击单元格，重新填入；\n" + " <7>手机号码：请填手机号码，不可输入空格或其他特殊符号；\n"
                    + " <8>角色：请下拉选择角色，不可随意输入，若未创建则没有下拉选项；\n"
                    + " <9>入职日期：请填入职日期(格式为2018-01-01或2018/01/01这样的格式)，入职日期须晚于当前日期、且不能早于（含等于）上一家公司的离职日期；北京地区入职时间只能为今日；\n"
                    + " <10>文件导入到系统时，会进行判断处理，若有数据导入失败，请下载错误信息表，重新编辑；";

            /**** 获取部门列表 ***/
            List<ComDepartTreeResultDto> comDepartList = comDepartMapper.getComDepartByComId(Long.parseLong(comId));

            /**** 拼接部门树 ***/
            List<ComDepartTreeResultDto> list = new ArrayList<>();
            for (ComDepartTreeResultDto dto : comDepartList) {
                List<ComDepartTreeResultDto> childrenList = new ArrayList<ComDepartTreeResultDto>();
                for (ComDepartTreeResultDto dto2 : comDepartList) {
                    if (dto2.getParentDepartId() != null && dto.getDepartId().equals(dto2.getParentDepartId())) {
                        childrenList.add(dto2);
                    }
                }
                dto.setChildren(childrenList);
                list.add(dto);
            }

            List<ComDepartTreeResultDto> comDeparts = new ArrayList<ComDepartTreeResultDto>();
            int level = 1;
            for (ComDepartTreeResultDto depart : list) {
                if (depart.getParentDepartId() == null || depart.getParentDepartId() == -1L) {
                    getDepartChildren(comDeparts, depart, level);
                }
            }
            String[] comDepartArr = new String[comDeparts.size()];
            for (int i = 0; i < comDeparts.size(); i++) {
                comDepartArr[i] = comDeparts.get(i).getDepartName() + "-" + comDeparts.get(i).getDepartId();
            }

            /**** 获取人员类别 ***/

            List<Map<String, String>> perTypeList = comDepartMapper.getComPerType(Long.parseLong(comId));
            String[] perTypeArr = new String[perTypeList.size()];
            for (int i = 0; i < perTypeList.size(); i++) {
                perTypeArr[i] = perTypeList.get(i).get("label") + "-" + perTypeList.get(i).get("codeValue");
            }

            /** 身份证类型 **/
            String[] idCardType = {"居民身份证（户口簿）-1"};

            /*** 下拉框数据 需要校验是否需要填充 ***/
            List<Integer> selectRowList = Lists.newArrayList(2);

            List<String[]> selectData = new ArrayList<String[]>();
            if (comDepartArr.length > 0) {
                selectData.add(comDepartArr);
            }
            if (idCardType.length > 0) {
                selectData.add(idCardType);
            }
            if (perTypeArr.length > 0) {
                selectData.add(perTypeArr);
            }

            /*** 下拉表的序号数组 ***/
            Integer[] selectRows = new Integer[selectRowList.size()];
            selectRowList.toArray(selectRows);

            /*** 填充必填样式 ***/
            CellStyle style1 = ExcelUtil.getNecessaryTitleStyle(wb);

            /*** 填充非必填样式 ***/
            CellStyle style2 = ExcelUtil.getCommonTitleStyle(wb);

            /*** 填充文本样式 ***/
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);

            /**** 生成sheet1的内容 ***/
            HSSFRow rowFirst = sheet1.createRow(0); // 第一个sheet的第一行为标题
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short) 11);
            titleFont.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            titleFont.setFontName("黑体");
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            rowFirst.setHeight((short) (4000));
            sheet1.addMergedRegion(new CellRangeAddress(0, (short) 0, 0, 7));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle);

            HSSFRow rowSecond = sheet1.createRow(1);
            rowSecond.setHeight((short) 500);

            /*** 写第二行 ***/
            String[] handers = {"部门", "*姓名", "*证件类型", "*证件号码", "*手机号码", "*人员类型", "角色", "*入职日期"};
            int column;
            for (int i = 0; i < handers.length; i++) {
                HSSFCell cell = rowSecond.createCell(i); // 获取第二行的每个单元格
                switch (i) {
                    case 0:
                        column = 8000;
                        break;
                    case 2:
                        column = 8000;
                        break;
                    case 6:
                        column = 8000;
                        break;
                    default:
                        column = 5000;
                        break;
                }
                sheet1.setColumnWidth(i, column); // 设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle); // 设置单元格格式 --文本格式

                if (i == 0 || i == 6) {
                    cell.setCellStyle(style2); // 必填项目
                } else {
                    cell.setCellStyle(style1);// 必填项目
                }
                cell.setCellValue(handers[i]); // 往单元格里写数据
            }

            /**** 填充下拉框数据 ***/

            String[] arr = {"A", "B", "C", "D", "E", "F", "G", "H", "I", "J"};
            int index = 0;
            HSSFRow row = null;
            for (int r = 0; r < selectRows.length; r++) {
                String[] dlData = selectData.get(r);// 获取下拉对象
                if (dlData != null) {
                    int rownum = selectRows[r];

                    /*** 1.设置有效性 ***/
                    String strFormula = "下拉列表!$" + arr[index] + "$1:$" + arr[index] + "$" + dlData.length; // Sheet2第A1到A10000作为下拉列表来源数据
                    // 设置数据有效性加载在哪个单元格上,参数分别是：从sheet3获取A1到A10000作为一个下拉的数据、起始行、终止行、起始列、终止列
                    sheet1.addValidationData(ExcelUtil.setDataValidation(strFormula, 2, 10000, rownum, rownum)); // 下拉列表元素很多的情况

                    /*** 2、生成sheet2内容 ***/
                    for (int j = 0; j < dlData.length; j++) {
                        if (index == 0) { // 第1个下拉选项，直接创建行、列
                            row = sheet2.createRow(j); // 创建数据行
                            sheet2.setColumnWidth(j, 5000); // 设置每列的列宽
                            row.createCell(0).setCellValue(dlData[j]); // 设置对应单元格的值
                        } else { // 非第1个下拉选项
                            int rowCount = sheet2.getLastRowNum();
                            if (j <= rowCount) { // 前面创建过的行，直接获取行，创建列
                                // 获取行，创建列
                                sheet2.getRow(j).createCell(index).setCellValue(dlData[j]); // 设置对应单元格的值
                            } else { // 未创建过的行，直接创建行、创建列
                                sheet2.setColumnWidth(j, 5000); // 设置每列的列宽
                                // 创建行、创建列
                                sheet2.createRow(j).createCell(index).setCellValue(dlData[j]); // 设置对应单元格的值
                            }
                        }
                    }
                }
                index++;
            }

            wb.write(os);
            os.close();
        } catch (Exception e) {
            throw new BusinessException(Result.ERROR, "导出Excel组织架构模板失败");
        } finally {
            if (os != null || wb != null) {
                try {
                    os.close();// 输入流关闭
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.success("导出Excel组织架构模板成功");
    }

    /**
     * 递归获取部门树表
     *
     * @param comDepartList
     * @param comDepart     by llc 2018-09-13
     */
    private void getDepartChildren(List<ComDepartTreeResultDto> comDepartList, ComDepartTreeResultDto comDepart,
                                   int level) {
        String es = "";
        for (int i = 1; i < level; i++) {
            es += "  ";
        }
        comDepart.setDepartName(es + comDepart.getDepartName());
        comDepartList.add(comDepart);
        if (comDepart.getChildren() != null && comDepart.getChildren().size() > 0) {
            level++;
            for (ComDepartTreeResultDto dto : comDepart.getChildren()) {
                getDepartChildren(comDepartList, dto, level);
            }
        }
    }

    /**
     * 导出组织架构Excel
     *
     * @param response
     * @return
     */
    @Override
    public Result exportDepart(HttpServletResponse response, ComDepartDto comDepartDto) throws BusinessException {
        try {
            OutputStream os = null;
            ExcelUtil<PerInfoExcelBean> util = new ExcelUtil(PerInfoExcelBean.class);
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;fileName=" + new String("组织架构.xls".getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            List<PerInfoExcelBean> list = perOrgRelationMapper.exportDepart(comDepartDto.getComId());
            if (list != null && list.size() > 0) {
                for (PerInfoExcelBean perInfoExcelBean : list) {
                    perInfoExcelBean.setIdCardType("身份证");
                }
            }
            util.exportExcel(list, "组织架构", 65535, os);
        } catch (Exception e) {
            throw new BusinessException(Result.ERROR, "导出Excel组织架构失败");
        }
        return Result.success("导出Excel组织架构成功");
    }

    @Override
    public Result getTreeDepartNotDataAuth(ComDepartDto comDepartDto) {
        Long parentDepartId = -1L;
        Long comId = comDepartDto.getComId();
        // 增加顶级公司信息
        List<ComDepartTreeDto> list = new ArrayList<ComDepartTreeDto>();
        ComBaseInfo comBaseInfo = comBaseInfoMapper.getByPrimaryKey(comId);
        if(comBaseInfo == null){
            throw new BusinessException(Result.ERROR, "未检索到企业信息，请刷新后重试");
        }
        ComDepartTreeDto root = new ComDepartTreeDto();
        root.setTitle(comBaseInfo.getComName());
        root.setKey("-1");
        root.setLabel(comBaseInfo.getComName());
        root.setValue("-1");
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("parentDepartId", parentDepartId);
        param.put("comId", comId);
        List<ComDepartTreeDto> childlist = new ArrayList<ComDepartTreeDto>();
        List<Map> allTreeDepart = comDepartMapper.getTreeDepartNotDataAuth(comId);// 获取部门列表
        childlist = getAllDepartChild(param, allTreeDepart);
        if (childlist != null && childlist.size() > 0) {
            root.setChildren(childlist);
        }
        list.add(root);
        return Result.success("", list);
    }

    /**
     * 组织架构部门树（新）
     *
     * @param comDepartDto
     * @return
     * @auth llc
     * @date 2019-07-16
     */
    @Override
    public Result getDepartTree(ComDepartDto comDepartDto) {
        String parentDepartId = "-1";
        if(comDepartDto.getComId() == null){
            return Result.success(Result.SUCCESS_QUERY_MSG);
        }
        Long comId = comDepartDto.getComId();
        List<OrgTreeDto> list = new ArrayList<OrgTreeDto>();
        // 获取公司信息
        Map<String, Object> m = perOrgRelationMapper.getComPerCount(comId);
        OrgTreeDto root = new OrgTreeDto();
        root.setDepartName(m.get("comName") != null ? m.get("comName").toString() : "");
        root.setPersonCount(Integer.parseInt(m.get("personCount").toString()));
        root.setDepartId("-1");
        root.setIsExistsDataAuth(CommonConst.N); // 默认没权限
        /*** 获取人员的通讯录数据权限涉及部门 ***/
        Map<String, Object> map = perOrgRelationService.getDataAuthOrgList(comDepartDto.getComId(), comDepartDto.getPerID());

        /*** 判断企业是否有数据权限 ***/
        if (ObjectUtil.equal(map.get("dataAuthType").toString(), DictConst.DATAAUTHTYPE_QGS)) {
            root.setIsExistsDataAuth(CommonConst.Y);
        } else {
            /*** 如果不是全公司的权限只需判断权限涉及部门是否包含此部门即可***/
            ArrayList<Long> orgIdList = (ArrayList<Long>) map.get("orgIdList");
            /*** 如果人员的数据权限涉及部门为空 ***/
            if (orgIdList != null && orgIdList.size() == 0) {

            } else {
                for (Long orgId : orgIdList) {
                    if (orgId.equals(comId)) {
                        root.setIsExistsDataAuth(CommonConst.Y);
                        break;
                    }
                }
            }
        }

        // 根据公司ID、登陆用户ID获取部门数据权限
        List<OrgTreeDto> departList = comDepartMapper.getDepartList(comId);

        /*** 存在子部门才需要判断数据权限 ***/
        if (departList != null && departList.size() > 0) {
            if (ObjectUtil.equal(map.get("dataAuthType").toString(), DictConst.DATAAUTHTYPE_QGS)) {
                for (OrgTreeDto orgTreeDto : departList) {
                    orgTreeDto.setIsExistsDataAuth(CommonConst.Y);
                }
            } else {
                /*** 如果不是全公司的权限只需判断权限涉及部门是否包含此部门即可***/
                ArrayList<Long> orgIdList = (ArrayList<Long>) map.get("orgIdList");
                /*** 如果人员的数据权限涉及部门为空 ***/
                if (orgIdList != null && orgIdList.size() == 0) {

                } else {
                    /*** 匹配到数据权限部门则置为存在数据权限 ***/
                    for (OrgTreeDto orgTreeDto : departList) {
                        for (Long orgId : orgIdList) {
                            if (orgId.equals(Long.parseLong(orgTreeDto.getDepartId().toString()))) {
                                orgTreeDto.setIsExistsDataAuth(CommonConst.Y);
                                break;
                            }
                        }
                    }
                }
            }
        }

        /*** 递归生成部门树 ***/
        List<OrgTreeDto> childlist = getDepartChild(parentDepartId, departList);
        if (childlist != null && childlist.size() > 0) {
            root.setChildDepart(childlist);
        }
        list.add(root);
        return Result.success(Result.SUCCESS_QUERY_MSG, list);
    }

    /**
     * 递归生成部门树
     *
     * @param
     * @return
     * @auth llc
     * @date 2019-07-16
     */
    @Override
    public List<OrgTreeDto> getDepartChild(String parentDepartId, List<OrgTreeDto> departList) {
        List<OrgTreeDto> deptVosList = new ArrayList<OrgTreeDto>();
        if (departList != null && departList.size() > 0) {
            for (OrgTreeDto depart : departList) {
                if (parentDepartId.equals(depart.getParentDepartId())) {
                    OrgTreeDto orgTreeDto = new OrgTreeDto();
                    orgTreeDto.setDepartId(depart.getDepartId());
                    orgTreeDto.setPersonCount(depart.getPersonCount());
                    orgTreeDto.setDepartName(depart.getDepartName());
                    orgTreeDto.setIsExistsDataAuth(depart.getIsExistsDataAuth());
                    orgTreeDto.setParentDepartId(depart.getParentDepartId());
                    orgTreeDto.setChildDepart(getDepartChild(depart.getDepartId(), departList));
                    deptVosList.add(orgTreeDto);
                }
            }
        }
        return deptVosList;
    }

    /**
     * 获取部门app通讯录权限设置信息
     *
     * @param comDepart
     * @return
     * @auth llc
     * @date 2019-07-26
     */
    @Override
    public Result getDepartAppAuthInfo(ComDepart comDepart) {
        if (comDepart.getDepartId() == null) {
            throw new BusinessException(Result.ERROR, "部门ID不能为空");
        }
        comDepart = comDepartMapper.getByPrimaryKey(comDepart.getDepartId());
        if (comDepart == null) {
            throw new BusinessException(Result.ERROR, "部门ID有误");
        }
        List<String> visibleDepartIdList = new ArrayList<>();


        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("limitSeeAppSwitch", comDepart.getLimitSeeAppSwitch());
        resultMap.put("limitSeeAppType", comDepart.getLimitSeeAppType());
        resultMap.put("visibleDepartIdList", visibleDepartIdList); // 特定部门列表
        return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
    }

}