package com.bcxin.oa.old.scheduling;

import com.bcxin.oa.old.service.web.CountPerAttendDateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
@Slf4j
public class CreateAttendCountReportHandler {

	@Resource
	private CountPerAttendDateService countPerAttendDateService;


	/**
	 * 定时生成考勤统计报表（每天凌晨1时执行）
	 */
	@Scheduled(cron = "0 0 1 * * ?")
	public void execute() {
		log.info("定时器生成昨天的考勤统计数据CreateAttendCountReportHandler启动！");
		countPerAttendDateService.createAttendCountReport();
		log.info("CreateAttendCountReportHandler执行结束");
	}
}
