package com.bcxin.oa.old.mapper.tempTask;

import com.bcxin.oa.old.entity.task.tempTask.ComTempTaskShare;
import com.bcxin.oa.old.dto.tempTask.ComTempShareComDto;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 临保任务共享企业mapper
 *
 * @author llc
 * @date 2020-02-24
 */
public interface ComTempTaskShareMapper extends CrudDao<ComTempTaskShare> {

    /**
     * 批量插入
     * @param list
     * @author llc
     * @date 2020-02-24
     * @return
     */
    int batchInsert(@Param("list")List<ComTempTaskShare> list);

    /**
     * 删除临保任务共享企业
     * @param comTempTaskId
     * @author llc
     * @date 2020-02-24
     * @return
     */
    int deleteByComTempTaskId(@Param("comTempTaskId")Long comTempTaskId);


    /**
     * 获取共享企业信息列表
     * @param comTempTaskIdList
     * @author llc
     * @date 2020-02-24
     * @return
     */
    List<ComTempShareComDto> getShareComInfoList(@Param("comTempTaskIdList") List<Long> comTempTaskIdList);


    /**
     * 获取共享企业ID列表
     * @param comTempTaskId
     * @author llc
     * @date 2020-03-17
     * @return
     */
    List<Long> getShareComIdList(@Param("comTempTaskId")Long comTempTaskId);


    /**
     * 获取企业信息列表
     * @param comIdList
     * @author llc
     * @date 2020-03-17
     * @return
     */
    List<Map<String,Object>> getComInfoByIdList(@Param("comIdList") List<Long> comIdList);
}