package com.bcxin.oa.old.mapper.salary;

import com.bcxin.oa.old.entity.salary.PerSalaryGrant;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.dto.salary.ExportPerSalaryMonthDTO;
import com.bcxin.oa.old.dto.salary.PerSalaryParamDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 人员薪资发放
 * 
 * @author zhangye
 * @since 2019-01-02 16:39:45
 */
public interface PerSalaryGrantMapper extends CrudDao<PerSalaryGrant> {

    List<PerSalaryGrant> getByIdList(@Param("idList")List idList);

    PerSalaryGrant getByPerIdAndMonth(@Param("perId")Long perId,@Param("month")String month);

    /**
     * 查询出薪资模板选择的人员（排除当月工资单已经确认的员工）
     * @param comId
     * @param grantYears
     * @return
     * @author llc
     * @date 2019-01-02
     */
    List<PerSalaryGrant> getSalaryTempPerList(@Param("comId") Long comId, @Param("grantYears") String grantYears);


    /**
     * 清除员工未确认的工资
     * @param comId
     * @param grantYears
     * @return
     * @author llc
     * @date 2019-01-08
     */
    int deletePerNoSureGrant(@Param("comId") Long comId, @Param("grantYears") String grantYears);


    /**
     * 根据人员集合查找生成的工资条集合
     * @param comId
     * @param grantYears
     * @return
     * @author lp
     * @date 2019-04-01
     */
    List<Long> getGrantByPerIdList(@Param("comId") Long comId, @Param("grantYears") String grantYears,@Param("perIdList")List perIdList);

    /**
     * 根据人员集合清除生成的工资条
     * @param comId
     * @param grantYears
     * @return
     * @author lp
     * @date 2019-04-01
     */
    int deletePerGrant(@Param("comId") Long comId, @Param("grantYears") String grantYears,@Param("perIdList")List perIdList);


    /**
     * 通过企业薪酬模板选择的人员批量插入到人员薪资发放表
     * @param comId
     * @param grantYears
     * @param createBy
     * @return
     * @author llc
     * @date 2019-01-02
     */
    int batchInsertPerSalaryGrant(@Param("comId") Long comId,@Param("grantYears") String grantYears,@Param("createBy") Long createBy ,@Param("list") List<PerSalaryGrant> perSalaryGrantList);

    /**
     * 通过导入的选择的人员批量插入到人员薪资发放表
     * @return
     * @author lp
     * @date 2019-04-01
     */
    int batchInsertPerSalaryGrantByPerIdList(@Param("list") List<PerSalaryGrant> perSalaryGrantList);

    /**
     * 批量更新个人工资
     * @param comId
     * @param grantYears
     * @return
     * @author llc
     * @date 2019-01-03
     */
    int batchUpdatePerSalary(@Param("comId") Long comId,@Param("grantYears") String grantYears);

    /**
     * 批量更新个人工资
     * @return
     * @author llc
     * @date 2019-01-03
     */
    int batchAccountSalary(@Param("list") List<String> list);

    /**
     * 个人确认工资条
     * @return
     * @author lp
     * @date 2019-01-03
     */
    int confirmPerSalary(@Param("perSalaryGrantId") Long perSalaryGrantId);


    /**
     * 获取企业某月份的核算记录数
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-01-11
     */
     int getSalaryCountByYears(PerSalaryParamDTO dto);


    /**
     * 人员月度工资列表
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-01-03
     */
    List<Map<String, Object>> getPerSalaryList(PerSalaryParamDTO dto);


    /**
     * 人员工资单列表
     *
     * @param paramDTO
     * @return
     * @author lp
     * @date 2019-01-03
     */
    List<Map<String, Object>> pagePerSalaryList(ParamDTO paramDTO);


    /**
     * 导出人员月度工资
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-01-17
     */
    List<ExportPerSalaryMonthDTO> getPerSalaryDetailList(PerSalaryParamDTO dto);


}