package com.bcxin.oa.old.entity.system;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 部门
 *
 * @author zhangye
 * @since 2017-12-22 10:37:18
 */
@TableName("com_depart")
@Data
public class ComDepart extends BaseEntity<ComDepart> {
	private static final long serialVersionUID = 180159436L;
	/**
	 * 部门ID
	 */
	@ApiModelProperty(value = "部门ID")
	private Long departId;

	/**
	 * 部门名称
	 */
	@ApiModelProperty(value = "部门名称")
	private String departName;

	/**
	 * 是否有效
	 */
	@ApiModelProperty(value = "是否有效")
	private String isActive = "1";

	/**
	 * 排序
	 */
	@ApiModelProperty(value = "排序")
	private Integer seq ;

	/**
	 * 部门树查询代码
	 */
	@ApiModelProperty(value = "部门树查询代码")
	private String departTreeCode;

	/**
	 * 组织新增事件ID
	 */
	@ApiModelProperty(value = "组织新增事件ID")
	private Long orgAddEventId;

	/**
	 * 上级部门ID
	 */
	@ApiModelProperty(value = "上级部门ID")
	private Long parentDepartId;

	/**
	 * 限制本部门人员查看App通讯录开关
	 */
	@ApiModelProperty(value = "限制本部门人员查看App通讯录开关")
	private String limitSeeAppSwitch;

	/**
	 * 限制查看app通讯录类型
	 */
	@ApiModelProperty(value = "限制查看app通讯录类型")
	private String limitSeeAppType;

	/**
	 * 企业ID
	 */
	@ApiModelProperty(value = "企业ID")
	private Long comId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getDepartId() {
		return departId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getOrgAddEventId() {
		return orgAddEventId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getParentDepartId() {
		return parentDepartId;
	}

}