package com.bcxin.oa.old.dto;

import com.bcxin.oa.old.entity.task.ComTaskInsidePush;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class ComTaskInsidePushDTO extends ComTaskInsidePush {

    @ApiModelProperty(value = "抄送人员ID数组")
    private String[] ccPerId;

    /**
     * json格式 "taskPerJson" : [{"perId":"人员ID","comTaskId":"任务ID","taskPerInsMode":"任务人员投保方式","taskInsSign":"任务人员投保标记"},
     * {"perId":"1","comTaskId":"1","taskPerInsMode":"1","taskInsSign":"1"}]
     */
    @ApiModelProperty(value = "出勤的人员Json")
    private String taskPerJson;

    @ApiModelProperty(value = "任务考勤类型")
    private String attendType;

    /**
     * 任务负责人ID
     */
    @ApiModelProperty(value = "任务负责人ID")
    private Long chargePerId;
    /**
     * 人员名称
     */
    private String perName;
    /**
     * 部门ID
     */
    private Long departId;
    /**
     * 部门名称
     */
    private String departName;
    /**
     * 公司名称
     */
    private String comName;
    /**
     * 人员详细信息
     */
    private List<ComTaskInsidePushDTO> perDetailList;

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getChargePerId() {
        return chargePerId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getDepartId() {
        return departId;
    }

}
