package com.bcxin.oa.old.controller.task;

import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.ComAttendTaskSchedulService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * @description：任务排班
 * @author：llc
 */
@RestController
@RequestMapping("/task/com-task-schedul")
@Api(tags = {""}, description = "任务排班")
public class ComTaskSchedulController extends BaseController {


    @Autowired
    private ComAttendTaskSchedulService comAttendTaskSchedulService;

    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "考勤任务排班管理", title = "考勤任务班次Excel模板导出", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "/export")
    public Result exportDepartTemp(ParamDTO paramDTO) throws BusinessException {
        return comAttendTaskSchedulService.export(getResponse(), paramDTO).setBack(getRequest());
    }


    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "考勤任务排班管理", title = "考勤任务班次EXCEL批量导入", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "/import")
    public Result importExcelPer(@RequestParam("xfile") MultipartFile xfile, ParamDTO paramDTO)
            throws BusinessException {
        return comAttendTaskSchedulService.importExcel(xfile, paramDTO).setBack(getRequest());
    }




}
