package com.bcxin.oa.old.controller.task;

import com.bcxin.oa.old.entity.task.ComTaskImplement;
import com.bcxin.oa.old.service.task.ComTaskFeedbackService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * App接口-添加任务日志记录管理
 *
 * @author zhangjianhua
 * @version 1.0
 */
@RestController
@RequestMapping("/task/com/task/feedback/")
@Api(tags = { "" }, description = "任务日志")
public class ComTaskFeedbackController extends BaseController {

	@Autowired
	private ComTaskFeedbackService comTaskFeedbackService;

	/**
	 * 查询任务日志记录
	 *
	 * @param comTaskImplement
	 * @return
	 * @author zhangjianhua
	 * @date 2018/04/18
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "查询任务日志记录", title = "保存", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "查询任务日志记录", httpMethod = "GET", notes = "查询任务日志记录", response = ComTaskImplement.class)
	@GetMapping(value = "list-com-task-feedback")
	public Result listComTaskFeedback(ComTaskImplement comTaskImplement) {
		return comTaskFeedbackService.listTaskFeedback(comTaskImplement).setBack(getRequest());
	}

}
