package com.bcxin.oa.old.controller.app.count;

import com.bcxin.oa.old.dto.count.AppPerTaskCountDTO;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.dto.user.CurrentUser;
import com.bcxin.oa.old.service.web.CountPerTaskDateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * app外勤统计的controller层
 * by llc 2019-01-23
 */
@RestController
@RequestMapping("task/app/count/task-count")
@Api(tags = {""}, description = "app外勤统计")
public class AppCountPerTaskDateController extends BaseController {
    @Resource
    private CountPerTaskDateService countPerTaskDateService;

    /**
     * APP-外勤统计
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-01-24
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "APP-外勤统计", title = "APP-外勤统计", systemType = Log.SYSTEMTYPE_PHONE)
    @ApiOperation(value = "APP-外勤统计", httpMethod = "GET", notes = "APP-外勤统计", response = Map.class)
    @GetMapping(value = "out-statistics")
    public Result outStatisTics(AppPerTaskCountDTO dto) {

        /*** 如果不传人员ID，默认是登录者本人 ***/
        if(dto.getPerId() == null){
            CurrentUser currentUser = new CurrentUser(getRequest());
            dto.setPerId(currentUser.getPerId());
        };
        Result result = countPerTaskDateService.outStatisTics(dto).setBack(getRequest());
        return result;
    }

}
