package com.bcxin.oa.old.common.utils;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.oa.old.common.BBDServiceConst;
import com.bcxin.oa.old.common.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName：com.bcxin.platform.util.bbd
 * @author：zhongjianhui @date：2018/3/20 18:17
 */
public class BBDService {

	private static Logger logger = LoggerFactory.getLogger(BBDService.class);

	/**************** 任务 *********************/

	/**
	 * 新增或更新任务
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method saveOrUpdateTask @date：2018/3/23 10:01 @params： * @param object
	 */
	public static Result saveOrUpdateTask(Object object, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_TASK;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 4.2.3.删除任务
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method deleteTask @date：2018/3/23 10:01 @params： * @param object
	 */
	public static Result deleteTask(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_TASK;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * 同步任务排班
	 * @param paramMap
	 * @param url
	 * @return
	 * @author llc
	 * @date 2020-03-25
	 */
	public static Result syncTaskSchedulForArs(Map<String,Object> paramMap, String url) {
		//获取结果
		String resultStr = HttpUtil.post(url,paramMap);
		ResultJson resultJson  = JSONObject.parseObject(resultStr, ResultJson.class);
//		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 同步任务打卡
	 * @param paramMap
	 * @param url
	 * @return
	 * @author llc
	 * @date 2020-03-26
	 */
	public static Result syncTaskCard(Map paramMap,  String url) {
		String resultStr = HttpUtil.post(url, paramMap);
		ResultJson resultJson  = JSONObject.parseObject(resultStr, ResultJson.class);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 同步任务班次
	 * @param paramMap
	 * @param url
	 * @return
	 * @author llc
	 * @date 2020-03-27
	 */
	public static Result syncComShift(Map paramMap, String url) {
		return callARSInterface(url,paramMap);
	}


	/**
	 * 调用ars接口
	 * @param url
	 * @param paramMap
	 * @return
	 */
	public static Result callARSInterface(String url, Map paramMap){
		//获取结果
		String resultStr = HttpUtil.post(url, paramMap);
		try {
			ResultJson resultJson = JSONObject.parseObject(resultStr, ResultJson.class);
			if (resultJson != null && resultJson.isSuccessful()) {
				return Result.success(Result.SUCCESS_MSG);
			} else {
				return Result.fail(resultJson.getMsg());
			}
		}catch (Exception e){
			return Result.fail("发生未知错误");
		}
	}


	/**
	 * 删除任务班次
	 * @param paramMap
	 * @param url
	 * @return
	 * @author llc
	 * @date 2020-03-26
	 */
	public static Result deleteComShift(Map paramMap,  String url) {
		String resultStr = HttpUtil.post(url, paramMap);
		ResultJson resultJson  = JSONObject.parseObject(resultStr, ResultJson.class);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * 增加驻勤人员
	 * @param paramMap
	 * @param url
	 * @return
	 * @author llc
	 * @date 2020-04-17
	 */
	public static Result addTaskPer(Map paramMap, String url) {
		String resultStr = HttpUtil.post(url, paramMap);
		ResultJson resultJson  = JSONObject.parseObject(resultStr, ResultJson.class);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * 移除驻勤人员
	 * @param paramMap
	 * @param url
	 * @return
	 * @author llc
	 * @date 2020-04-17
	 */
	public static Result removeTaskPer(Map paramMap, String url) {
		String resultStr = HttpUtil.post(url, paramMap);
		ResultJson resultJson  = JSONObject.parseObject(resultStr, ResultJson.class);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * <b> 校验人员是否有人口库照片接口 </b>
	 * @author ZXF
	 * @create 2020/09/09 0009 14:37
	 * @version
	 * @注意事项 </b>
	 */
	public static Result checkPersonBaseHeadImg(Map paramMap, String url) {
		String resultStr = HttpUtil.post(url, paramMap);
		ResultJson resultJson  = JSONObject.parseObject(resultStr, ResultJson.class);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG,resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * <b> 联名卡申请前向百保盾发起资格证推送状态变更 </b>
	 * @author ZXF
	 * @create 2020/09/09 0009 14:37
	 * @version
	 * @注意事项 </b>
	 */
	public static Result applyBeforeSend(Map paramMap, String url) {
		String resultStr = HttpUtil.post(url, paramMap);
		ResultJson resultJson  = JSONObject.parseObject(resultStr, ResultJson.class);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG,resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**************** 安保公司信息 *********************/

	/**
	 * 4.2.1.创建或更新安保公司信息
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method saveOrUpdateCompany @date：2018/3/22 10:01 @params： * @param
	 *         object
	 */
	public static Result saveOrUpdateCompany(Object object, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_COMPANY;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}



	/**************** 劳动合同 *********************/

	/**
	 * 签订、变更、续签、完成劳动合同
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method saveOrUpdateHt @date：2018/3/24 10:01 @params： * @param object
	 */
	public static Result saveOrUpdateHt(Object object, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_UPDATE_HT;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 解除劳动合同
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method relieveHt @date：2018/3/24 10:01 @params： * @param object
	 */
	public static Result relieveHt(Object object, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_RELIEVE_HT;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**************** 服务合同信息 *********************/
	/**
	 * 创建或更新服务合同信息
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method saveOrUpdateContract @date：2018/3/21 10:01 @params： * @param
	 *         object
	 */
	public static Result saveOrUpdateContract(Object object, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_CONTRACT;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 删除服务合同信息
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method deleteContract @date：2018/3/22 10:01 @params： * @param object
	 */
	public static Result deleteContract(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_CONTRACT;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 创建或更新跨区经营情况信息
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method saveOrUpdateSbBusinessManagement @date：2018/3/21 10:01 @params：
	 *         * @param object
	 */
	public static Result saveOrUpdateSbBusinessManagement(Object object, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_SBBUSINESSMANAGEMENT;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 删除跨区经营情况信息
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method deleteSbBusinessManagement @date：2018/3/22 10:01 @params：
	 *         * @param object
	 */
	public static Result deleteSbBusinessManagement(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_SBBUSINESSMANAGEMENT;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 4.5.10.创建或更新海外经营情况信息
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method saveOrUpdateSbBusinessOutsideManagement @date：2018/3/21
	 *         10:01 @params： * @param object
	 */
	public static Result saveOrUpdateSbBusinessOutsideManagement(Object object, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_SBBUSINESSOUTSIDEMANAGEMENT;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 4.5.11.删除海外经营情况信息
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method deleteSbBusinessOutsideManagement @date：2018/3/22 10:01 @params：
	 *         * @param object
	 */
	public static Result deleteSbBusinessOutsideManagement(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_SBBUSINESSOUTSIDEMANAGEMENT;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 4.5.12.创建或更新保安奖励信息
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method saveOrUpdateSbReward @date：2018/3/21 10:01 @params： * @param
	 *         object
	 */
	public static Result saveOrUpdateSbReward(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_SBREWARD;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 删除保安奖励信息
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method deleteContract @date：2018/3/22 10:01 @params： * @param object
	 */
	public static Result deleteSbReward(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_SBREWARD;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 4.8.1.创建或更新自行招用保安员单位
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method saveOrUpdateSecurityTraincompany @date：2018/3/21 10:01 @params：
	 *         * @param object
	 */
	public static Result saveOrUpdateSecurityTraincompany(Object object, String configURL) {
		// configURL= commonService.getSystemConfig(CommonConst.TRACK_ +
		// comTask.getProvince())
		String url = configURL + BBDServiceConst.SAVE_SECURITYTRAIN;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 4.8.2.删除自行招用保安单位信息
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method deleteContract @date：2018/3/22 10:01 @params： * @param object
	 */
	public static Result deleteSecurityTraincompany(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_SECURITYTRAIN;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 4.8.3.创建或更新保安培训单位信息
	 *
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Decription:
	 * @author：zhongjianhui
	 * @method saveOrUpdateContract @date：2018/3/21 10:01 @params： * @param
	 *         object
	 */
	public static Result saveOrUpdateSecurityConfesscompany(Object object, String configURL) {
		// configURL= commonService.getSystemConfig(CommonConst.TRACK_ +
		// comTask.getProvince())
		String url = configURL + BBDServiceConst.SAVE_SECURITYCONFESS;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * 创建或更新保安员处罚信息
	 *
	 * @param paramMap
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method saveOrUpdateSbPunish
	 * @Date: 2018/3/21
	 * @Description:
	 */
	public static Result saveOrUpdateSbPunish(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_SBPUNISH;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 删除保安员处罚信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method deleteSbPunis
	 * @Date: 2018/3/21 10:57
	 * @Description:
	 */
	public static Result deleteSbPunis(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_SBPUNISH;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 创建好人好事要闻信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method addSecurityGoodThing
	 * @Date: 2018/3/21 11:16
	 * @Description:
	 */
	public static Result saveSecurityGoodThing(Object object, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_SECURITYGOODTHING;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 更新好人好事要闻信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method updateSecurityGoodThing
	 * @Date: 2018/3/21 16:53
	 * @Description:
	 */

	public static Result updateSecurityGoodThing(Object object, String configURL) {
		// configURL= commonService.getSystemConfig(CommonConst.TRACK_ +
		// comTask.getProvince())
		String url = configURL + BBDServiceConst.UPDATEBYID_SECURITYGOODTHING;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 删除好人好事要闻信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method deleteSecurityGoodThing
	 * @Date: 2018/3/21 17:23
	 * @Description:
	 */
	public static Result deleteSecurityGoodThing(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETEBYID_SECURITYGOODTHING;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 创建或更新出资人信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method updateInvestor
	 * @Date: 2018/3/22 9:22
	 * @Description:
	 */
	public static Result updateInvestor(Object object, String configURL) {
		String url = configURL + BBDServiceConst.UPDATE_INVESTOR;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 删除出资人信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method deleteInvestor
	 * @Date: 2018/3/22 10:34
	 * @Description:
	 */
	public static Result deleteInvestor(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_INVESTOR;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 创建或更新发票信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wangjianchi
	 * @method saveInvoice
	 * @Date: 2018/11/22 10:34
	 * @Description:
	 */
	public static Result saveInvoice(Object object, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_INVOICE;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 创建或更新管理层信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method updateManagementInfo
	 * @Date: 2018/3/22 10:38
	 * @Description:
	 */
	public static Result updateManagementInfo(Object object, String configURL) {
		String url = configURL + BBDServiceConst.UPDATE_MANAGEMENTINFO;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 删除管理层信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method deleteManagementInfo
	 * @Date: 2018/3/22 10:40
	 * @Description:
	 */
	public static Result deleteManagementInfo(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_MANAGEMENTINFO;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 创建或更新技防设备信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method updateSafety
	 * @Date: 2018/3/22 13:07
	 * @Description:
	 */
	public static Result updateSafety(Object object, String configURL) {
		String url = configURL + BBDServiceConst.UPDATE_SAFETY;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 删除技防设备信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method deleteSafety
	 * @Date: 2018/3/22 13:11
	 * @Description:
	 */
	public static Result deleteSafety(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_SAFETY;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 创建或更新部门信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method saveOrUpdateOrganization
	 * @Date: 2018/3/22 14:44
	 * @Description:
	 */
	public static Result saveOrUpdateOrganization(Object object, String configURL) {
		String url = configURL + BBDServiceConst.SAVEORUPDATE_ORGANIZATION;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 删除保安培训单位信息
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method deleteOrganization
	 * @Date: 2018/3/22 14:49
	 * @Description:
	 */
	public static Result deleteOrganization(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_ORGANIZATION;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 更新安保人员
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method updateSecurityPerson
	 * @Date: 2018/3/23 9:30
	 * @Description:
	 */
	public static Result updateSecurityPerson(Object object, String configURL) {
		String url = configURL + BBDServiceConst.UPDATE_SECURITYPERSON;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * 更新人员证件照片
	 *
	 * @param object
	 * @param configURL
	 * @throws Exception
	 * @auth llc
	 * @date 2019-08-23
	 */
	public static Result updatePerColorPhoto(Object object, String configURL) {
		String url = configURL + BBDServiceConst.UPDATE_PER_COLOR_PHOTO;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * 清除人员证件照片
	 *
	 * @param object
	 * @param configURL
	 * @throws Exception
	 * @auth llc
	 * @date 2020-07-01
	 */
	public static Result deletePerColorPhoto(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_PER_COLOR_PHOTO;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * 更新人员一寸免冠彩照(企业上传)
	 *
	 * @param object
	 * @param configURL
	 * @throws Exception
	 * @auth llc
	 * @date 2020-08-27
	 */
	public static Result updatePerOneInchcolourPhoto(Object object, String configURL) {
		String url = configURL + BBDServiceConst.UPDATE_PER_ONE_INCH_COLOR_PHOTO;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * 更新人员认证状态
	 *
	 * @param url
	 * @return com.bcxin.platform.util.Result
	 * @method updatePerAuthStatus
	 */
	public static Result updatePerAuthStatus(Map<String, Object> paramMap, String url) {
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * <b> 人员认证申诉信息推送 </b>
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @author ZXF
	 * @create 2020/01/09 0009 10:12
	 * @version
	 * @注意事项 </b>
	 */
	public static Result savePerAuthApprove(Object object, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_APPEAL;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 批量更新安保人员
	 *
	 * @param paramMap
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wangjianchi
	 * @method updateSecurityPersonBatch
	 * @Date: 2018/11/20 15:30
	 * @Description:
	 */
	public static Result updateSecurityPersonBatch(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.UPDATE_SECURITYPERSON_BATCH;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 保安员证书批量同步
	 *
	 * @param paramMap
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: llc
	 * @date 2019-08-07
	 */
	public static Result batchUpdateCertificate(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.BATCH_UPDATE_CERTIFICATE;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 批量调整部门人员
	 *
	 * @param object
	 * @param configURL
	 * @return
	 */
	public static Result batchAdjustDepart(Object object, String configURL) {
		String url = configURL + BBDServiceConst.ADJUST_DEPT_BATCH;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 删除安保人员
	 *
	 * @param object
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method deleteSecurityPerson
	 * @Date: 2018/3/23 9:35
	 * @Description:
	 */
	public static Result deleteSecurityPerson(Object object, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_SECURITYPERSON;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 批量删除安保人员
	 *
	 * @param paramMap
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: wuxiaozhen
	 * @method deleteSecurityPerson
	 * @Date: 2018/3/23 9:35
	 * @Description:
	 */
	public static Result deleteSecurityPersonBatch(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.DELETE_SECURITYPERSON_BATCH;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 新增轨迹
	 *
	 * @param paramMap
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: zhangye
	 * @method saveTaskTrack
	 * @Date: 2018/3/30
	 * @Description:
	 */
	public static Result saveTaskTrack(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.TASK_SAVETRACK;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG, resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 查看轨迹
	 *
	 * @param taskFeedbackId
	 * @param configURL
	 * @return com.bcxin.platform.util.Result
	 * @Author: zhangye
	 * @method listTaskTrack
	 * @Date: 2018/3/30
	 * @Description:
	 */
	public static Result listTaskTrack(String taskFeedbackId, String sessionId, String configURL) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("sessionId", sessionId);
		String url = configURL + BBDServiceConst.TASK_FINDTRACKLIST;
		url = url.replaceAll("#", taskFeedbackId);
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson.getData() != null && "[]".equals(resultJson.getData())) {
			resultJson.setData(null);
		}
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG, resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 注册
	 *
	 * @param object
	 * @param configURL
	 * @return
	 */
	public static Result saveBaseInfo(Object object, String configURL) {

		String url = configURL + BBDServiceConst.SAVE_BASEINFO;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}

	}

	/**
	 * 修改密码
	 *
	 * @param object
	 * @param configURL
	 * @return
	 */
	public static Result updatePassWord(Object object, String configURL) {
		String url = configURL + BBDServiceConst.UPDATE_PASS_WORD;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}

	}

	/**
	 * WEB端帐号登录
	 *
	 * @param object
	 * @param configURL
	 * @return
	 */
	public static Result loginWeb(Object object, String configURL) {
		String url = configURL + BBDServiceConst.LOGIN_WEB;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 子系统用户登陆验证
	 *
	 * @param object
	 * @param configURL
	 */
	public static Result login(Object object, String configURL) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("comId", object);
		String url = configURL + BBDServiceConst.SAAS_LOGIN;
		ResultJson resultJson = HttpUtils.sendHttp(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * 百保盾登录鉴权
	 *
	 * @param comIdEncode
	 * @param configURL
	 * @author llc
	 * @date 2020-06-05
	 */
	public static Result bbdLogin(String comIdEncode, String configURL) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("comId", comIdEncode);
		String url = configURL + BBDServiceConst.BBD_LOGIN;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_QUERY_MSG, resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 解除合同
	 *
	 * @param object
	 * @param configURL
	 */
	public static Result bbdRelieveComContract(Object object, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_RELIEVE_HT;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 修改安保人员手机号码
	 *
	 * @param object
	 * @param configURL
	 * @return
	 */
	public static Result saveOrUpdatePerPhone(Object object, String configURL) {
		String url = configURL + BBDServiceConst.UPDATE_SECURITYPERSON_PHONE;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 获取人口库照片
	 *
	 * @param paramMap
	 * @param configURL
	 * @return
	 */
	public static Result getPersonImg(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.GET_PERSON_IMG_DATA;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG,resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 获取年报信息
	 *
	 * @param object
	 * @param configURL
	 * @return
	 */
	public static Result getYearReportData(Object object, String configURL) {
		String url = configURL + BBDServiceConst.FIND_YEARREPORT_DATA;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success("", resultJson.getData());
		} else {
			return Result.success("", null);
		}
	}

	/**
	 * 人员新增修改证书
	 *
	 * @param object
	 * @param configURL
	 * @return
	 */
	public static Result saveOrUpdateCertificate(Object object, String configURL) {
		String url = configURL + BBDServiceConst.UPDATE_SECURITYPERSON_UPDATECERTIFICATE;
		ResultJson resultJson = HttpUtils.sendHttp(url, object);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 更新保安员位置
	 *
	 * @param paramMap
	 * @param configURL
	 * @return
	 */
	public static Result updateLocation(Map<String,Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.UPDATE_LOCATION;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 人脸识别
	 *
	 * @param data
	 * @param configURL
	 * @return
	 */
	public static Result authenticationFaceTask(Map<String, String> data, String configURL) {
		String url = configURL + BBDServiceConst.VALIDATE_BATCH;
		ResultJson resultJson = HttpUtils.pairSendHttp(url, data);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * <b> 获取保安资格证申请的审批状态码 </b>
	 * 002：待审批
	 * 003：审批通过
	 * 004：审批不通过
	 * 005：审批中
	 * @author ZXF
	 * @create 2019/03/07 0007 14:41
	 * @version
	 * @注意事项 </b>
	 */
	public static Result getApprovalStatus(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.GET_APPROVAL_STATUS_DATA;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG,resultJson.getData());
		} else {;
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * <b> 获取保安资格证申请详细信息 </b>
	 * @author ZXF
	 * @create 2019/03/07 0007 17:02
	 * @version
	 * @注意事项 </b>
	 */
	public static Result getBayzgzInfo(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.GET_BAYZGZ_DETAIL_DATA;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG,resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * 保安员资格证重复提交校验
	 *
	 * @param paramMap
	 * @auth llc
	 * @date 2019-08-28
	 * @return
	 */
	public static Result bayzgzCheckResubmit(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.BAYZGZ_CHECK_RESUBMIT;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG,resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * <b> 组装保安资格证信息推送百保盾 </b>
	 * @author ZXF
	 * @create 2019/03/08 0008 14:17
	 * @version
	 * @注意事项 </b>
	 */
	public static Result saveBayzgz(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.SAVE_BAYZGZ_DATA;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG,resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 消息已读
	 * @param paramMap
	 * @param configURL
	 * @return
	 */
	public static Result updateMessageRead(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.UPDATE_MESSAGE_READ;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG,resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 *
	 * 撤销保安员资格证申报申请
	 * @param paramMap
	 * @auth llc
	 * @date 2019-10-12
	 * @return
	 */
	public static Result revokeBayzgzSbApply(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.REVOKE_BAYZGZSB_APPLY;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG,resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 同步企业人员投保状态
	 *
	 * @param url
	 * @return com.bcxin.platform.util.Result
	 * @method syncPerPolicyStatus
	 */
	public static Result syncPerPolicyStatus(Map<String, Object> paramMap, String url) {
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 统一请求方法
	 * @Author: wangjianjun
	 * @Date: 10/15/2019
	 * @param paramMap
	 * @param configURL
	 * @param type
	 * @return:
	 */
	public static Result common(Map<String, Object> paramMap, String configURL,String type) {
		String url = configURL + type;
		String resultStr = HttpUtil.post(url, paramMap);
		ResultJson resultJson  = JSONObject.parseObject(resultStr, ResultJson.class);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG);
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

	/**
	 * 获取企业问题人员数量
	 *
	 * @auth llc
	 * @date 2020-08-03
	 * @return
	 */
	public static Result getComProblemPerNum(Map<String, Object> paramMap, String configURL) {
		String url = configURL + BBDServiceConst.GET_PROBLEM_PER_NUM;
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG,resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}


	/**
	 * 同步补贴发放状态
	 * @param paramMap
	 * @param url
	 * @return
	 * @author llc
	 * @date 2020-10-19
	 */
	public static Result syncSubsidyGrantStatus(Map paramMap, String url) {
		ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
		if (resultJson != null && resultJson.isSuccessful()) {
			return Result.success(Result.SUCCESS_MSG,resultJson.getData());
		} else {
			return Result.fail(resultJson.getMsg());
		}
	}

}
