package com.bcxin.tenant.data.etc.tasks.components.builder;

import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import org.springframework.util.StringUtils;

import java.util.Map;
import java.util.Optional;

public class EmployeeRecordDataBuilder extends EmployeeDataBuilder{
    @Override
    public Map<String, Object> build(CacheProvider cacheProvider, Map<String, Object> data, String tableName, DockMapDbExtractor dbExtractor) {
        String employeeId = (String) getKeyValue(data, "after.employee_id");
        /**
         * EntryJob=0/LeaveJob=1
         */
        int afterStatus = (int) getKeyValue(data, "after.status");
        int beforeStatus = -1;
        Object bs = getKeyValue(data, "before.status");
        if (bs != null) {
            beforeStatus = (int) bs;
        }


        if (!StringUtils.hasLength(employeeId)) {
            employeeId = (String) getKeyValue(data, "before.employee_id");
            beforeStatus = (int) getKeyValue(data, "before.status");
        }

        /**
         * 只监听入离职发生变更的事件
         */
        if (beforeStatus != afterStatus) {
            Map<String, String> employee = cacheProvider.getDocumentFromCache(DocumentType.Employee,
                    employeeId,dbExtractor);
            if (employee != null) {
                Optional<String> organizationKeyOptional = employee.keySet().stream()
                        .filter(ix -> ix.equalsIgnoreCase("organization_id"))
                        .findFirst();

                if (organizationKeyOptional.isPresent()) {
                    data.put("after.organization_id", employee.get(organizationKeyOptional.get()));
                }

                Optional<String> tenantUserIdOptional = employee.keySet().stream()
                        .filter(ix -> ix.equalsIgnoreCase("tenant_user_id"))
                        .findFirst();

                if (tenantUserIdOptional.isPresent()) {
                    data.put("after.tenant_user_id", employee.get(tenantUserIdOptional.get()));
                }
            } else {
                //throw new NoFoundEventException(String.format("EmployeeEventDataBuilder: 无法从redis获取有效得tenant_employees(id=%s)归集信息", employeeId));
            }
        }

        return super.build(cacheProvider, data, tableName, dbExtractor);
    }
}
