package com.bcxin.tenant.data.etc.tasks.components.builder;

import com.bcxin.event.core.FlinkConstants;
import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class EmployeeDataBuilder extends BusinessDataBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EmployeeDataBuilder.class);

    @Override
    public Map<String, Object> build(CacheProvider cacheProvider, Map<String, Object> data, String tableName, DockMapDbExtractor dbExtractor) {
        data = super.build(cacheProvider, data, tableName, dbExtractor);

        return processEmployee(cacheProvider, tableName, data, dbExtractor);
    }

    protected Map<String, Object> processEmployee(CacheProvider cacheProvider, String tableName, Map<String, Object> _parameters, DockMapDbExtractor dbExtractor) {
        String userId = (String) getKeyValue(_parameters, "after.tenant_user_id");
        String employeeId = null;

        if (this instanceof EmployeeRecordDataBuilder) {
            employeeId = (String) getKeyValue(_parameters, "after.employee_id");
        } else if (this instanceof AttendanceSitePersonDataBuilder) {
            employeeId = (String) getKeyValue(_parameters, "after.ITEM_securityId");
        }else {
            /**
             * 如果是employee本身的话, 则取Id
             */
            employeeId = (String) getKeyValue(_parameters, "after.id");
        }

        /**
         * 为了取职员的驻勤信息
         */
        Map<String, String> employeeMap = null;
        if (!tableName.equalsIgnoreCase("tenant_employees")) {
            employeeMap = cacheProvider.getDocumentFromCache(DocumentType.Employee,
                    employeeId, dbExtractor);
        }else {
            /**
             * 针对入职或者复制的职员信息; 我们需要获取所在的驻勤点信息
             *
             */
            if (tableName.equalsIgnoreCase("tenant_employees") && _parameters != null) {
                if (_parameters.get("after.status").equals(0) &&
                        (_parameters.get("before.status") == null || _parameters.get("before.status").equals(1))) {
                    employeeMap = new HashMap<>();
                    for (String key : _parameters.keySet()) {
                        Object value = _parameters.get(key);
                        if (value != null) {
                            employeeMap.put(key, String.valueOf(value));
                        }
                    }
                }
            }
        }

        String department_id = (String) getKeyValue(_parameters, "after.department_id");
        if (employeeMap != null && !employeeMap.isEmpty()) {
            /**
             * 针对职员的话; 添加如下
             */
            if ((this instanceof EmployeeDataBuilder) &&
                    !(this instanceof EmployeeRecordDataBuilder) &&
                    !(this instanceof AttendanceSitePersonDataBuilder)) {
                if (!employeeMap.containsKey(FlinkConstants.EMPLOYEE_STATION_ID)) {
                    Map<String, String> stationMap =
                            cacheProvider.getDocumentFromCache(
                                    DocumentType.Employee_Selected_Security_Station,
                                    employeeId,
                                    dbExtractor
                            );
                    if (stationMap != null && !stationMap.isEmpty()) {
                        employeeMap.put(FlinkConstants.EMPLOYEE_STATION_ID, stationMap.get("ID"));
                        employeeMap.put(FlinkConstants.EMPLOYEE_STATION_NAME, stationMap.get("ITEM_attendanceSiteName"));
                        employeeMap.put(FlinkConstants.EMPLOYEE_STATION_SUPERVISE_DEPART_ID, stationMap.get("ITEM_officePoliceAddressID"));
                        employeeMap.put(FlinkConstants.EMPLOYEE_STATION_SUPERVISE_DEPART_NAME, stationMap.get("ITEM_officePoliceAddress"));
                        employeeMap.put(FlinkConstants.EMPLOYEE_STATION_SUPERVISE_DEPART_ID_INDEX, stationMap.get("ITEM_officePoliceIDIndex"));
                    }
                }

                _parameters.put(FlinkConstants.EMPLOYEE_STATION_ID, employeeMap.get(FlinkConstants.EMPLOYEE_STATION_ID));
                _parameters.put(FlinkConstants.EMPLOYEE_STATION_NAME, employeeMap.get(FlinkConstants.EMPLOYEE_STATION_NAME));
                _parameters.put(FlinkConstants.EMPLOYEE_STATION_SUPERVISE_DEPART_ID, employeeMap.get(FlinkConstants.EMPLOYEE_STATION_SUPERVISE_DEPART_ID));
                _parameters.put(FlinkConstants.EMPLOYEE_STATION_SUPERVISE_DEPART_NAME, employeeMap.get(FlinkConstants.EMPLOYEE_STATION_SUPERVISE_DEPART_NAME));
                _parameters.put(FlinkConstants.EMPLOYEE_STATION_SUPERVISE_DEPART_ID_INDEX, employeeMap.get(FlinkConstants.EMPLOYEE_STATION_SUPERVISE_DEPART_ID_INDEX));
            } else {
                department_id = (String) employeeMap.get("department_id");
                for (String hKey : employeeMap.keySet()) {
                    _parameters.put(String.format("employee.%s", hKey), formatValue(hKey, employeeMap.get(hKey)));
                }
            }
        }

        /**
         * 针对驻勤人员的话; 那么用户信息; 我们先从employeeMap中获取
         */
        if (this instanceof AttendanceSitePersonDataBuilder
                && !CollectionUtils.isEmpty(employeeMap)) {
            userId = employeeMap.get("tenant_user_id");
        }

        Map<String, String> userMap = cacheProvider.getDocumentFromCache(DocumentType.User, userId, dbExtractor);
        if (userMap != null && userMap.size() > 1) {
            boolean checkedStatus = false;
            for (String hKey : userMap.keySet()) {
                _parameters.put(String.format("user.%s", hKey), formatValue(hKey, userMap.get(hKey)));
                if (hKey.equalsIgnoreCase("checked_status") && !"0".equalsIgnoreCase(userMap.get(hKey))) {
                    checkedStatus = true;
                }
            }

            Object afterStatus = getKeyValue(_parameters, "after.status");
            Object beforeStatus = getKeyValue(_parameters, "before.status");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Object after_hired_operator_created_time = getKeyValue(_parameters, "after.hired_operator_created_time");
            Object before_hired_operator_created_time = getKeyValue(_parameters, "before.hired_operator_created_time");
            boolean isTimeChanged = false;
            try {
                isTimeChanged = (before_hired_operator_created_time == null ||
                        after_hired_operator_created_time == null ||
                        !dateFormat.format(before_hired_operator_created_time).equalsIgnoreCase(dateFormat.format(after_hired_operator_created_time))
                );
            } catch (Exception ex) {
                isTimeChanged = true;
                ex.printStackTrace();
                try {
                    logger.error("时间(before={};after={})比较发生异常:{}", before_hired_operator_created_time, after_hired_operator_created_time, ex);
                } catch (Exception ee) {
                }
            }

            /**
             * 仅入离职的是才进行操作;不限制核验状态
             */
            if (true &&
                    (
                            beforeStatus == null || !String.valueOf(beforeStatus).equalsIgnoreCase(String.valueOf(afterStatus)) ||
                                    (before_hired_operator_created_time == null ||
                                            after_hired_operator_created_time == null ||
                                            !dateFormat.format(before_hired_operator_created_time).equalsIgnoreCase(dateFormat.format(after_hired_operator_created_time))
                                    )
                    )
            ) {
                _parameters = this.bindUserBusinessData(userId, _parameters, cacheProvider, dbExtractor);
            }
        } else {
            //throw new NoFoundEventException(String.format("EmployeeDataBuilder: 无法从redis获取有效得tenant_users(id=%s)归集信息", userId));
        }

        Map<String, String> departmentMap = cacheProvider.getDocumentFromCache(DocumentType.Department, department_id, dbExtractor);
        if (departmentMap != null && !departmentMap.isEmpty()) {
            for (String hKey : departmentMap.keySet()) {
                _parameters.put(String.format("department.%s", hKey), formatValue(hKey, departmentMap.get(hKey)));
            }
        }

        return _parameters;
    }
}
