package com.bcxin.tenant.data.etc.tasks.components.builder;
import com.bcxin.event.core.exceptions.NoFoundEventException;
import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import redis.clients.jedis.Jedis;

import java.sql.Connection;
import java.util.Map;

/**
 * 一般的所有业务数据; 我们添加了组织节点给Jdbc脚本使用
 */
public class BusinessDataBuilder extends DataBuilderAbstract{
    @Override
    public Map<String, Object> build(CacheProvider cacheProvider, Map<String, Object> data, String tableName, DockMapDbExtractor dbExtractor) {
        DataCoreMeta meta = this.getDataMeta(data);
        String domainId = meta.getDomainId();
        if (tableName.equalsIgnoreCase("tenant_companies")) {
            domainId = meta.getId();
        }

        Map<String, String> organizationMap = cacheProvider.getDocumentFromCache(DocumentType.Organization, domainId, dbExtractor);
        if (organizationMap != null) {
            for (String hKey : organizationMap.keySet()) {
                data.put(String.format("organization.%s", hKey).toLowerCase(), formatValue(hKey, organizationMap.get(hKey)));
            }
        } else {
            //throw new NoFoundEventException(String.format("BusinessDataBuilder: 无法从redis获取有效得tenant_organizations(id=%s)归集信息", meta.getDomainId()));
        }

        return data;
    }
}
