package com.bcxin.flink.cdc.kafka.source.task.utils;

import com.bcxin.flink.cdc.kafka.source.task.cdcs.CdcSourceMeta;
import com.bcxin.flink.cdc.kafka.source.task.compnents.JdbcDbReaderComponent;
import com.bcxin.flink.cdc.kafka.source.task.compnents.dtos.OrgInfoDTO;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.springframework.util.StringUtils;

public class RecordHeadUtil {
    public static Headers extractHeaders(CdcSourceMeta sourceMeta, JdbcDbReaderComponent dbReaderComponent) {
        Headers headers = new RecordHeaders();

        String domainId = sourceMeta.getDomainId();
        if (StringUtils.hasLength(domainId)) {
            headers.add("org_id", domainId.getBytes());

            OrgInfoDTO orgInfo = dbReaderComponent.getRegionCode(domainId, sourceMeta);

            if (orgInfo!=null) {
                if (StringUtils.hasLength(orgInfo.getRegionCode())) {
                    headers.add("region_code", orgInfo.getRegionCode().getBytes());
                }

                if (StringUtils.hasLength(orgInfo.getInstitutionalCode())) {
                    headers.add("institutional_code", orgInfo.getInstitutionalCode().getBytes());
                }
            }
        }

        if (sourceMeta.getSuperviseDepartId() != null) {
            headers.add("supervise_depart_id", sourceMeta.getSuperviseDepartId().getBytes());
        }

        headers.add("db-name", sourceMeta.getDbName().getBytes());
        headers.add("table-name", sourceMeta.getTableName().getBytes());

        return headers;
    }
}
