package com.bcxin.flink.cdc.kafka.source.task.proerpties;

import lombok.Getter;

import java.io.Serializable;

@Getter
public class KafkaConfigProperty implements Serializable {
    private final String bootstrapServer;
    private final String topicPrefix;
    private final String consumerGroupId;

    public KafkaConfigProperty(String bootstrapServer, String topicPrefix, String consumerGroupId) {
        this.bootstrapServer = bootstrapServer;
        this.topicPrefix = topicPrefix;
        this.consumerGroupId = consumerGroupId;

        if (this.getTopicPrefix() == null || this.getTopicPrefix() == "") {
            throw new IllegalArgumentException("kafka.cdc.topic.prefix 主题前置配置不能为空");
        }
    }

    public static KafkaConfigProperty create(String bootstrapServer, String topicPrefix, String consumerGroupId) {
        return new KafkaConfigProperty(bootstrapServer,topicPrefix,consumerGroupId);
    }

    public String getActualTopicName(String dbName,String tableName) {
        return this.getTopicPrefix().replace("[dbName]", dbName)
                .replace("[tableName]", tableName);
    }
}
