package com.bcxin.flink.cdc.kafka.source.task.compnents;

import com.bcxin.flink.cdc.kafka.source.task.cdcs.CdcSourceMeta;
import com.bcxin.flink.cdc.kafka.source.task.compnents.dtos.OrgInfoDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class JdbcDbReaderComponent implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(JdbcDbReaderComponent.class);
    private static Map<String,OrgInfoDTO> orgRegionCodeMaps = new HashMap<>();
    private String url;
    private String userName;
    private String password;

    private JdbcDbReaderComponent(){}

    public OrgInfoDTO getRegionCode(String orgId, CdcSourceMeta meta) {
        OrgInfoDTO orgInfo = orgRegionCodeMaps.get(orgId);
        if (orgInfo == null) {
            String sql = String.format(
                    "SELECT a.supervise_region_code,a.institutional_code FROM obpm2.tenant_organizations a where a.id='%s'", orgId);
            StringBuilder track = new StringBuilder();

            try {
                try (Connection connection = DriverManager.getConnection(url, userName, password);) {
                    track.append("获取connection链接信息;");
                    try (PreparedStatement statement = connection.prepareStatement(sql)) {
                        track.append("获取statement链接信息;");
                        try (ResultSet resultSet = statement.executeQuery()) {
                            track.append("获取resultSet链接信息;");
                            if (resultSet.next()) {
                                String regionCode = resultSet.getString("supervise_region_code");
                                if (!StringUtils.hasLength(regionCode)) {
                                    regionCode = "none";
                                }
                                String institutionalCode = resultSet.getString("institutional_code");

                                orgInfo = OrgInfoDTO.create(regionCode,institutionalCode);
                                orgRegionCodeMaps.put(orgId, orgInfo);
                                return orgInfo;
                            }
                        }
                    }
                } catch (Exception ex) {
                    logger.error("v3.获取企业({})所属的监管区域信息发生(跟踪信息={})异常(sql={})", orgId, track, sql, ex);
                }
            } catch (Exception ex) {
                logger.error("v3.({})获取连接信息发生异常", orgId, ex);
            }
            finally {
                if (orgInfo == null) {
                    logger.error("v3.找不到对应的组织信息({})", orgId);
                } else {
                    //logger.error("v3.通过数据库查询企业({})的区域({})信息", orgId, orgInfo.getRegionCode(), orgInfo.getInstitutionalCode());
                }
            }
        }

        return orgInfo;
    }

    public static JdbcDbReaderComponent build(Properties properties) {
        JdbcDbReaderComponent component = new JdbcDbReaderComponent();
        component.url = properties.getProperty("datasource.url");
        component.userName = properties.getProperty("datasource.username");
        component.password = properties.getProperty("datasource.password");

        return component;
    }
}
