package com.bcxin.flink.cdc.kafka.source.task.cdcs;

import lombok.Data;

import java.io.Serializable;

@Data
public class BinlogOffsetValue implements Serializable {
    private String file;
    private long offset;
    private String gtIds;

    private String note;

    public static BinlogOffsetValue create(String file, long offset,String gtIds) {
        BinlogOffsetValue binlogOffsetValue = new BinlogOffsetValue();
        binlogOffsetValue.setOffset(offset);
        binlogOffsetValue.setFile(file);
        binlogOffsetValue.setGtIds(gtIds);

        return binlogOffsetValue;
    }

    public void changeNote(String note) {
        this.setNote(note);
    }
}
