/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.admin.SystemRoleMenu;
import com.zbkj.service.dao.SystemRoleMenuDao;
import com.zbkj.service.service.SystemRoleMenuService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SystemRoleMenuServiceImpl
extends ServiceImpl<SystemRoleMenuDao, SystemRoleMenu>
implements SystemRoleMenuService {
    @Resource
    private SystemRoleMenuDao dao;

    @Override
    public Boolean deleteByRid(Integer rid) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.eq(SystemRoleMenu::getRid, (Object)rid);
        return this.dao.delete((Wrapper)luw) > 0;
    }

    @Override
    public List<Integer> getMenuListByRid(Integer rid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SystemRoleMenu::getMenuId});
        lqw.eq(SystemRoleMenu::getRid, (Object)rid);
        List roleMenuList = this.dao.selectList((Wrapper)lqw);
        return roleMenuList.stream().map(SystemRoleMenu::getMenuId).collect(Collectors.toList());
    }

    @Override
    public Boolean deleteByRidAndMenuId(Integer rid, Integer menuId) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.eq(SystemRoleMenu::getRid, (Object)rid);
        luw.eq(SystemRoleMenu::getMenuId, (Object)menuId);
        return this.dao.delete((Wrapper)luw) > 0;
    }

    @Override
    public Boolean deleteByRidAndMenuIdList(Integer rid, List<Integer> menuIdList) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.eq(SystemRoleMenu::getRid, (Object)rid);
        luw.in(SystemRoleMenu::getMenuId, menuIdList);
        return this.dao.delete((Wrapper)luw) > 0;
    }
}

