package com.zbkj.admin.controller.platform;

import cn.hutool.core.collection.CollectionUtil;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxBillGenerateSettleRequest;
import com.zbkj.common.request.BcxPerformanceReportSearchRequest;
import com.zbkj.common.request.BcxSettleBillSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.*;
import com.zbkj.common.response.excel.*;
import com.zbkj.common.result.CommonResult;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.common.utils.ExportUtil;
import com.zbkj.service.service.BcxSettleBillService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * description: 业绩账单表 控制层
 * author : linchunpeng
 * date : 2023/8/3
 */
@Slf4j
@Api(tags = "分销系统-业绩账单表控制层")
@RestController
@RequestMapping("/api/admin/platform/bcx/settle/bill")
public class BcxSettleBillController {
    
    @Autowired
    private BcxSettleBillService bcxSettleBillService;

    @ApiOperation(value = "业绩账单统计 ")
    @RequestMapping(value = "/statistics", method = RequestMethod.GET)
    public CommonResult<BcxSettleBillStatisticsResponse> statistics(@Validated BcxSettleBillSearchRequest searchRequest) throws ParseException {
        return CommonResult.success(bcxSettleBillService.statistics(searchRequest));
    }

//    @PreAuthorize("hasAuthority('platform:bcx:settle:bill:channel')")
    @ApiOperation(value = "渠道业绩账单")
    @RequestMapping(value = "/channel/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleBillResponse>> getChannelList(@Validated BcxSettleBillSearchRequest searchRequest,
                                                                                 @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setSearchType(1);
        return CommonResult.success(CommonPage.restPage(bcxSettleBillService.getPage(searchRequest, pageParamRequest)));
    }

//    @PreAuthorize("hasAuthority('platform:bcx:settle:bill:department')")
    @ApiOperation(value = "部门业绩账单")
    @RequestMapping(value = "/department/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleBillResponse>> getDepartmentList(@Validated BcxSettleBillSearchRequest searchRequest,
                                                                                    @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setSearchType(2);
        return CommonResult.success(CommonPage.restPage(bcxSettleBillService.getPage(searchRequest, pageParamRequest)));
    }

//    @PreAuthorize("hasAuthority('platform:bcx:settle:bill:department:member')")
    @ApiOperation(value = "部门成员业绩账单")
    @RequestMapping(value = "/department/member/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleBillResponse>> getDepartmentMemberList(@Validated BcxSettleBillSearchRequest searchRequest,
                                                                                          @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setSearchType(3);
        return CommonResult.success(CommonPage.restPage(bcxSettleBillService.getPage(searchRequest, pageParamRequest)));
    }

//    @PreAuthorize("hasAuthority('platform:bcx:settle:bill:fxs')")
    @ApiOperation(value = "分销商业绩账单")
    @RequestMapping(value = "/fxs/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleBillResponse>> getFxsList(@Validated BcxSettleBillSearchRequest searchRequest,
                                                                             @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setSearchType(4);
        return CommonResult.success(CommonPage.restPage(bcxSettleBillService.getPage(searchRequest, pageParamRequest)));
    }

//    @PreAuthorize("hasAuthority('platform:bcx:settle:bill:fxy')")
    @ApiOperation(value = "分销员业绩账单")
    @RequestMapping(value = "/fxy/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleBillResponse>> getFxyList(@Validated BcxSettleBillSearchRequest searchRequest,
                                                                             @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setSearchType(5);
        return CommonResult.success(CommonPage.restPage(bcxSettleBillService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "业绩账单详情")
    @RequestMapping(value = "/detail/{id}", method = RequestMethod.GET)
    public CommonResult<BcxSettleBillDetailResponse> detail(@PathVariable(name = "id") Long id)  {
        return CommonResult.success(bcxSettleBillService.findId(id));
    }

    @ApiOperation(value = "获取生成结算单数据")
    @RequestMapping(value = "/get/settle/info", method = RequestMethod.POST)
    public CommonResult<BcxSettleBillInfoResponse> getSettleInfo(@RequestBody @Validated BcxBillGenerateSettleRequest request) {
        return CommonResult.success(bcxSettleBillService.getSettleInfo(request));
    }

    @ApiOperation(value = "生成结算单")
    @RequestMapping(value = "/generate/settle", method = RequestMethod.POST)
    public CommonResult<Object> generateSettle(@RequestBody @Validated BcxBillGenerateSettleRequest request) {
        return CommonResult.success(bcxSettleBillService.generateSettle(request));
    }

    @ApiOperation(value = "手动生成账单")
    @RequestMapping(value = "/manual/generate/{billPeriod}", method = RequestMethod.POST)
    public CommonResult<Object> manualGenerate(@PathVariable(name = "billPeriod")String billPeriod) throws ParseException {
        Date endTime = DateUtils.parseDate(billPeriod + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
        bcxSettleBillService.generateSettleBill(endTime);
        return CommonResult.success();
    }

    @ApiOperation(value = "渠道业绩账单-导出excel")
    @RequestMapping(value = "/channel/list/excel", method = {RequestMethod.GET})
    public void channelListExcel(@Validated BcxSettleBillSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxSettleBillChannelExcelDto> resultList = Collections.singletonList(new BcxSettleBillChannelExcelDto());
        searchRequest.setSearchType(1);
        List<BcxSettleBillResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxSettleBillChannelExcelDto excelVo = new BcxSettleBillChannelExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxSettleBillChannelExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("渠道业绩账单", resultList, response);
    }

    @ApiOperation(value = "部门业绩账单-导出excel")
    @RequestMapping(value = "/department/list/excel", method = {RequestMethod.GET})
    public void departmentListExcel(@Validated BcxSettleBillSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxSettleBillDepartmentExcelDto> resultList = Collections.singletonList(new BcxSettleBillDepartmentExcelDto());
        searchRequest.setSearchType(2);
        List<BcxSettleBillResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxSettleBillDepartmentExcelDto excelVo = new BcxSettleBillDepartmentExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxSettleBillDepartmentExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("部门业绩账单", resultList, response);
    }

    @ApiOperation(value = "部门成员业绩账单-导出excel")
    @RequestMapping(value = "/department/member/list/excel", method = {RequestMethod.GET})
    public void departmentMemberListExcel(@Validated BcxSettleBillSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxSettleBillDepartmentMemberExcelDto> resultList = Collections.singletonList(new BcxSettleBillDepartmentMemberExcelDto());
        searchRequest.setSearchType(3);
        List<BcxSettleBillResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxSettleBillDepartmentMemberExcelDto excelVo = new BcxSettleBillDepartmentMemberExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxSettleBillDepartmentMemberExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("部门成员业绩账单", resultList, response);
    }

    @ApiOperation(value = "分销商业绩账单-导出excel")
    @RequestMapping(value = "/fxs/list/excel", method = {RequestMethod.GET})
    public void fxsListExcel(@Validated BcxSettleBillSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxSettleBillFxsExcelDto> resultList = Collections.singletonList(new BcxSettleBillFxsExcelDto());
        searchRequest.setSearchType(4);
        List<BcxSettleBillResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxSettleBillFxsExcelDto excelVo = new BcxSettleBillFxsExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxSettleBillFxsExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("分销商业绩账单", resultList, response);
    }

    @ApiOperation(value = "分销员业绩账单-导出excel")
    @RequestMapping(value = "/fxy/list/excel", method = {RequestMethod.GET})
    public void fxyListExcel(@Validated BcxSettleBillSearchRequest searchRequest, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        List<BcxSettleBillFxyExcelDto> resultList = Collections.singletonList(new BcxSettleBillFxyExcelDto());
        searchRequest.setSearchType(5);
        List<BcxSettleBillResponse> list = getList(searchRequest);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                BcxSettleBillFxyExcelDto excelVo = new BcxSettleBillFxyExcelDto();
                BeanUtils.copyProperties(reportResponse, excelVo);
                return excelVo;
            }).collect(Collectors.toList());
        }
        ExportUtil<BcxSettleBillFxyExcelDto> exportUtil = new ExportUtil<>();
        exportUtil.export("分销员业绩账单", resultList, response);
    }

    /**
     * description：获取列表
     * author：linchunpeng
     * date：2023/8/29
     */
    private List<BcxSettleBillResponse> getList(BcxSettleBillSearchRequest searchRequest) {
        try {
            PageParamRequest pageParamRequest = new PageParamRequest();
            pageParamRequest.setLimit(10000);
            PageInfo<BcxSettleBillResponse> page = bcxSettleBillService.getPage(searchRequest, pageParamRequest);
            return page.getList();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }
    
}