package com.zbkj.admin.controller.platform;

import com.zbkj.common.model.bcx.BcxOrderFapiao;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxOrderFapiaoQueryRequest;
import com.zbkj.common.response.bcx.BcxOrderFapiaoResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.service.bcx.BcxOrderFapiaoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 平台 发票管理 控制层
 */
@Slf4j
@Api(tags = "平台-发票管理-控制器")
@RestController
@RequestMapping("/api/admin/platform/fapiao")
public class BcxPlatformOrderFapiaoController {

    @Autowired
    private BcxOrderFapiaoService bcxOrderFapiaoService;

    @ApiOperation("查询分页-发票管理列表")
//    @PreAuthorize("hasAuthority('merchant:attachment:list')")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxOrderFapiaoResponse>> queryPagedList(@Validated BcxOrderFapiaoQueryRequest request,
                                                                           @Validated PageParamRequest pageParamRequest) {
        SecurityUtil.getLoginUserVo();
        return CommonResult.success(CommonPage.restPage(bcxOrderFapiaoService.queryPlatformFapiaoPagedList(request, pageParamRequest)));
    }
}
