package com.zbkj.common.response.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "BcxSummaryInfo对象", description = "通用列表统计信息")
public class BcxSummaryInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "总笔数")
    private Integer totalCount;

    @ApiModelProperty(value = "总金额")
    private BigDecimal totalPrice;
}
