package com.zbkj.common.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * description: 收益中心统计 response对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxBrokerageStatisticsResponse对象", description = "收益中心统计 response对象")
public class BcxBrokerageStatisticsResponse implements Serializable {

    @ApiModelProperty(value = "待结算佣金")
    private BigDecimal waitSettledBrokeragePrice = BigDecimal.ZERO;

    @ApiModelProperty(value = "冻结佣金")
    private BigDecimal frozenBrokeragePrice = BigDecimal.ZERO;

    @ApiModelProperty(value = "已结算佣金")
    private BigDecimal settledBrokeragePrice = BigDecimal.ZERO;

    @ApiModelProperty(value = "总收益")
    private BigDecimal totalBrokeragePrice = BigDecimal.ZERO;

    @ApiModelProperty(value = "总笔数")
    private Integer totalCount = 0;

}