package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * description: 结算表
 * author : linchunpeng
 * date : 2023/9/1
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_settle")
@ApiModel(value = "BcxSettle对象", description = "结算表")
public class BcxSettle implements Serializable {
    
    @ApiModelProperty(value = "主键id")
    @TableId(value = "id")
    private Long id;
    
    @ApiModelProperty(value = "账单id")
    private Long settleBillId;
    
    @ApiModelProperty(value = "关联id：渠道表id，部门表id，部门成员表id，用户表id")
    private Long belongId;
    
    @ApiModelProperty(value = "关联类型：1渠道表，2部门表，3部门成员表，4用户表-分销商，5用户表-分销员")
    private Integer belongType;
    
    @ApiModelProperty(value = "账期，yyyy-MM")
    private String billPeriod;
    
    @ApiModelProperty(value = "结算单号")
    private String settleNo;
    
    @ApiModelProperty(value = "结算数量")
    private Integer reportCount;
    
    @ApiModelProperty(value = "实付总金额")
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "佣金总金额")
    private BigDecimal brokerageTotalPrice;

    @ApiModelProperty(value = "已结算佣金金额")
    private BigDecimal brokerageSettledPrice;

    @ApiModelProperty(value = "未结算佣金金额")
    private BigDecimal brokerageNotSettledPrice;
    
    @ApiModelProperty(value = "结算状态：1待结算，2已结算")
    private Integer settleStatus;
    
    @ApiModelProperty(value = "支付方式：1线下结算，2企业钱包结算，3第三方支付结算")
    private Integer payWay;
    
    @ApiModelProperty(value = "结算时间")
    private Date settleTime;

    @ApiModelProperty(value = "发票/结算凭证：1已上传，2未上传")
    private Integer uploadAttachments;
    
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

}